/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import groovy.lang.Closure;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionAdapter;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.internal.BuildScopeListenerRegistrationListener;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.tasks.TaskState;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.execution.ProjectExecutionServiceRegistry;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeExecutor;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.execution.plan.ScheduledWork;
import org.gradle.execution.plan.TaskNode;
import org.gradle.execution.taskgraph.NotifyTaskGraphWhenReadyBuildOperationType;
import org.gradle.execution.taskgraph.TaskExecutionGraphExecutionListener;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.Cast;
import org.gradle.internal.InternalListener;
import org.gradle.internal.MutableReference;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.util.Path;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NullMarked
public class DefaultTaskExecutionGraph
implements TaskExecutionGraphInternal {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskExecutionGraph.class);
    private final PlanExecutor planExecutor;
    private final List<NodeExecutor> nodeExecutors;
    private final GradleInternal gradleInternal;
    private final ListenerBroadcast<TaskExecutionGraphListener> graphListeners;
    private final ListenerBroadcast<TaskExecutionGraphExecutionListener> internalGraphListeners;
    private final ListenerBroadcast<TaskExecutionListener> taskListeners;
    private final BuildScopeListenerRegistrationListener buildScopeListenerRegistrationListener;
    private final ServiceRegistry globalServices;
    private final BuildOperationRunner buildOperationRunner;
    private final ListenerBuildOperationDecorator listenerBuildOperationDecorator;
    private FinalizedExecutionPlan executionPlan;
    private List<Task> allTasks = Collections.emptyList();
    private boolean hasFiredWhenReady;

    public DefaultTaskExecutionGraph(PlanExecutor planExecutor, List<NodeExecutor> nodeExecutors, BuildOperationRunner buildOperationRunner, ListenerBuildOperationDecorator listenerBuildOperationDecorator, GradleInternal gradleInternal, ListenerBroadcast<TaskExecutionGraphListener> graphListeners, ListenerBroadcast<TaskExecutionGraphExecutionListener> internalGraphListeners, ListenerBroadcast<TaskExecutionListener> taskListeners, BuildScopeListenerRegistrationListener buildScopeListenerRegistrationListener, ServiceRegistry globalServices) {
        this.planExecutor = planExecutor;
        this.nodeExecutors = nodeExecutors;
        this.buildOperationRunner = buildOperationRunner;
        this.listenerBuildOperationDecorator = listenerBuildOperationDecorator;
        this.gradleInternal = gradleInternal;
        this.graphListeners = graphListeners;
        this.internalGraphListeners = internalGraphListeners;
        this.taskListeners = taskListeners;
        this.buildScopeListenerRegistrationListener = buildScopeListenerRegistrationListener;
        this.globalServices = globalServices;
        this.executionPlan = FinalizedExecutionPlan.EMPTY;
    }

    @Override
    public void populate(FinalizedExecutionPlan plan) {
        this.executionPlan.close();
        this.executionPlan = plan;
        this.allTasks = ImmutableList.copyOf(this.executionPlan.getContents().getTasks());
        if (!this.hasFiredWhenReady) {
            this.fireWhenReady();
            this.hasFiredWhenReady = true;
        } else if (!this.graphListeners.isEmpty()) {
            LOGGER.info("Ignoring listeners of task graph ready event, as this build ({}) has already executed work.", (Object)this.gradleInternal.getIdentityPath());
        }
    }

    @Override
    public ExecutionResult<Void> execute(FinalizedExecutionPlan plan) {
        this.assertIsThisGraphsPlan(plan);
        if (!this.hasFiredWhenReady) {
            throw new IllegalStateException("Task graph should be populated before execution starts.");
        }
        ((TaskExecutionGraphExecutionListener)this.internalGraphListeners.getSource()).beforeGraphExecutionStarts(this);
        try {
            ProjectExecutionServiceRegistry projectExecutionServices = new ProjectExecutionServiceRegistry(this.globalServices);
            try {
                ExecutionResult<Void> executionResult = this.executeWithServices(projectExecutionServices);
                projectExecutionServices.close();
                return executionResult;
            }
            catch (Throwable throwable) {
                try {
                    projectExecutionServices.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            this.executionPlan.close();
            this.executionPlan = FinalizedExecutionPlan.EMPTY;
        }
    }

    private void assertIsThisGraphsPlan(FinalizedExecutionPlan plan) {
        if (plan != this.executionPlan) {
            throw new IllegalArgumentException();
        }
    }

    private ExecutionResult<Void> executeWithServices(ProjectExecutionServiceRegistry projectExecutionServices) {
        return this.planExecutor.process(this.executionPlan.asWorkSource(), new BuildOperationAwareExecutionAction(this.buildOperationRunner.getCurrentOperation(), new InvokeNodeExecutorsAction(this.nodeExecutors, projectExecutionServices)));
    }

    public void addTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.add((Object)this.decorateListener("TaskExecutionGraph.addTaskExecutionGraphListener", listener));
    }

    private TaskExecutionGraphListener decorateListener(String registrationPoint, TaskExecutionGraphListener listener) {
        return this.listenerBuildOperationDecorator.decorate(registrationPoint, TaskExecutionGraphListener.class, listener);
    }

    public void removeTaskExecutionGraphListener(TaskExecutionGraphListener listener) {
        this.graphListeners.remove((Object)listener);
    }

    public void whenReady(Closure closure) {
        this.graphListeners.add((Dispatch)new ClosureBackedMethodInvocationDispatch("graphPopulated", this.listenerBuildOperationDecorator.decorate("TaskExecutionGraph.whenReady", (Closure)Cast.uncheckedCast((Object)closure))));
    }

    public void whenReady(Action<TaskExecutionGraph> action) {
        this.graphListeners.add((Object)this.decorateListener("TaskExecutionGraph.whenReady", arg_0 -> action.execute(arg_0)));
    }

    @Override
    public void addExecutionListener(TaskExecutionGraphExecutionListener listener) {
        this.internalGraphListeners.add((Object)listener);
    }

    @Override
    public void removeExecutionListener(TaskExecutionGraphExecutionListener listener) {
        this.internalGraphListeners.remove((Object)listener);
    }

    public void addTaskExecutionListener(TaskExecutionListener listener) {
        this.notifyListenerRegistration("TaskExecutionGraph.addTaskExecutionListener", listener);
        this.taskListeners.add((Object)listener);
    }

    public void removeTaskExecutionListener(TaskExecutionListener listener) {
        this.taskListeners.remove((Object)listener);
    }

    public void beforeTask(Closure closure) {
        this.notifyListenerRegistration("TaskExecutionGraph.beforeTask", closure);
        this.taskListeners.add((Dispatch)new ClosureBackedMethodInvocationDispatch("beforeExecute", closure));
    }

    public void beforeTask(final Action<Task> action) {
        this.notifyListenerRegistration("TaskExecutionGraph.beforeTask", action);
        this.taskListeners.add((Object)new TaskExecutionAdapter(){

            public void beforeExecute(Task task) {
                action.execute((Object)task);
            }
        });
    }

    public void afterTask(Closure closure) {
        this.notifyListenerRegistration("TaskExecutionGraph.afterTask", closure);
        this.taskListeners.add((Dispatch)new ClosureBackedMethodInvocationDispatch("afterExecute", closure));
    }

    public void afterTask(final Action<Task> action) {
        this.notifyListenerRegistration("TaskExecutionGraph.afterTask", action);
        this.taskListeners.add((Object)new TaskExecutionAdapter(){

            public void afterExecute(Task task, TaskState state) {
                action.execute((Object)task);
            }
        });
    }

    private void notifyListenerRegistration(String registrationPoint, Object listener) {
        if (listener instanceof InternalListener) {
            return;
        }
        this.buildScopeListenerRegistrationListener.onBuildScopeListenerRegistration(listener, registrationPoint, this);
    }

    public boolean hasTask(Task task) {
        return this.executionPlan.getContents().getTasks().contains(task);
    }

    @Override
    public @Nullable Task findTask(String path) {
        for (Task task : this.executionPlan.getContents().getTasks()) {
            if (!task.getPath().equals(path)) continue;
            return task;
        }
        return null;
    }

    public boolean hasTask(String path) {
        return this.findTask(path) != null;
    }

    @Override
    public int size() {
        return this.executionPlan.getContents().size();
    }

    public List<Task> getAllTasks() {
        return this.allTasks;
    }

    @Override
    public ScheduledWork collectScheduledWork() {
        MutableReference result = MutableReference.of(null);
        this.executionPlan.getContents().getScheduledNodes().visitNodes((nodes, entryNodes) -> result.set((Object)new ScheduledWork((List<? extends Node>)nodes, (Collection<? extends Node>)entryNodes)));
        ScheduledWork scheduledWork = (ScheduledWork)result.get();
        Preconditions.checkState((scheduledWork != null ? 1 : 0) != 0, (Object)"No scheduled work found");
        return scheduledWork;
    }

    public Set<Task> getDependencies(Task task) {
        TaskNode node = this.executionPlan.getContents().getNode(task);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Node dependencyNode : node.getDependencySuccessors()) {
            if (!(dependencyNode instanceof TaskNode)) continue;
            builder.add((Object)((TaskNode)dependencyNode).getTask());
        }
        return builder.build();
    }

    @Override
    public void resetState() {
        this.internalGraphListeners.removeAll();
        this.graphListeners.removeAll();
        this.taskListeners.removeAll();
        this.executionPlan.close();
        this.executionPlan = FinalizedExecutionPlan.EMPTY;
        this.allTasks = Collections.emptyList();
    }

    @Override
    public Set<Task> getFilteredTasks() {
        return this.executionPlan.getContents().getFilteredTasks();
    }

    private void fireWhenReady() {
        this.gradleInternal.getOwner().getProjects().withMutableStateOfAllProjects(() -> this.buildOperationRunner.run((RunnableBuildOperation)new NotifyTaskGraphWhenReady(this, (TaskExecutionGraphListener)this.graphListeners.getSource(), this.gradleInternal)));
    }

    private static class BuildOperationAwareExecutionAction
    implements Action<Node> {
        private final BuildOperationRef parentOperation;
        private final Action<Node> delegate;

        BuildOperationAwareExecutionAction(BuildOperationRef parentOperation, Action<Node> delegate) {
            this.parentOperation = parentOperation;
            this.delegate = delegate;
        }

        public void execute(Node node) {
            CurrentBuildOperationRef.instance().with(this.parentOperation, () -> this.delegate.execute((Object)node));
        }
    }

    private static class InvokeNodeExecutorsAction
    implements Action<Node> {
        private final List<NodeExecutor> nodeExecutors;
        private final ProjectExecutionServiceRegistry projectExecutionServices;

        public InvokeNodeExecutorsAction(List<NodeExecutor> nodeExecutors, ProjectExecutionServiceRegistry projectExecutionServices) {
            this.nodeExecutors = nodeExecutors;
            this.projectExecutionServices = projectExecutionServices;
        }

        public void execute(Node node) {
            NodeExecutionContext context = this.projectExecutionServices.forProject(node.getOwningProject());
            for (NodeExecutor nodeExecutor : this.nodeExecutors) {
                if (!nodeExecutor.execute(node, context)) continue;
                return;
            }
            throw new IllegalStateException("Unknown type of node: " + node);
        }
    }

    private static class NotifyTaskGraphWhenReady
    implements RunnableBuildOperation {
        private final TaskExecutionGraph taskExecutionGraph;
        private final TaskExecutionGraphListener graphListener;
        private final GradleInternal gradleInternal;

        private NotifyTaskGraphWhenReady(TaskExecutionGraph taskExecutionGraph, TaskExecutionGraphListener graphListener, GradleInternal gradleInternal) {
            this.taskExecutionGraph = taskExecutionGraph;
            this.graphListener = graphListener;
            this.gradleInternal = gradleInternal;
        }

        public void run(BuildOperationContext context) {
            this.graphListener.graphPopulated(this.taskExecutionGraph);
            context.setResult((Object)NotifyTaskGraphWhenReadyBuildOperationType.RESULT);
        }

        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.gradleInternal.contextualize("Notify task graph whenReady listeners")).details((Object)new NotifyTaskGraphWhenReadyDetails(this.gradleInternal.getIdentityPath()));
        }
    }

    private static class NotifyTaskGraphWhenReadyDetails
    implements NotifyTaskGraphWhenReadyBuildOperationType.Details {
        private final Path buildPath;

        NotifyTaskGraphWhenReadyDetails(Path buildPath) {
            this.buildPath = buildPath;
        }

        public String getBuildPath() {
            return this.buildPath.getPath();
        }
    }
}

