/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.jspecify.annotations.Nullable;

public class DefaultProjectRegistry
implements ProjectRegistry,
HoldsProjectState {
    private final Map<String, ProjectInternal> projects = new HashMap<String, ProjectInternal>();
    private final Map<String, Set<ProjectInternal>> subProjects = new HashMap<String, Set<ProjectInternal>>();

    @Override
    public void addProject(ProjectInternal project) {
        ProjectInternal previous = this.projects.put(project.getPath(), project);
        if (previous != null) {
            throw new IllegalArgumentException(String.format("Multiple projects registered for path '%s'.", project.getPath()));
        }
        this.subProjects.put(project.getPath(), new HashSet());
        this.addProjectToParentSubProjects(project);
    }

    @Override
    public void discardAll() {
        this.projects.clear();
        this.subProjects.clear();
    }

    private void addProjectToParentSubProjects(ProjectInternal project) {
        for (ProjectIdentifier loopProject = project.getParentIdentifier(); loopProject != null; loopProject = loopProject.getParentIdentifier()) {
            this.subProjects.get(loopProject.getPath()).add(project);
        }
    }

    @Override
    public @Nullable ProjectInternal getProject(String path) {
        return this.projects.get(path);
    }

    @Override
    public Set<ProjectInternal> getAllProjects(String path) {
        HashSet<ProjectInternal> result = new HashSet<ProjectInternal>(this.getSubProjects(path));
        if (this.projects.get(path) != null) {
            result.add(this.projects.get(path));
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Set<ProjectInternal> getSubProjects(String path) {
        Set<ProjectInternal> subprojects = this.subProjects.get(path);
        return subprojects != null && !subprojects.isEmpty() ? Collections.unmodifiableSet(subprojects) : Collections.emptySet();
    }
}

