/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.Optional;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.VfsRelativePath;

public abstract class AbstractInvalidateChildHandler<T, RESULT>
implements ChildMap.NodeHandler<T, ChildMap<RESULT>> {
    private final ChildMap.InvalidationHandler<T, RESULT> handler;

    public AbstractInvalidateChildHandler(ChildMap.InvalidationHandler<T, RESULT> handler) {
        this.handler = handler;
    }

    public abstract ChildMap<RESULT> getChildMap();

    public abstract ChildMap<RESULT> withReplacedChild(RESULT var1);

    public abstract ChildMap<RESULT> withReplacedChild(String var1, RESULT var2);

    public abstract ChildMap<RESULT> withRemovedChild();

    @Override
    public ChildMap<RESULT> handleAsDescendantOfChild(VfsRelativePath pathInChild, T child) {
        Optional<RESULT> invalidatedChild = this.handler.handleAsDescendantOfChild(pathInChild, child);
        return invalidatedChild.map(this::withReplacedChild).orElseGet(this::withRemovedChild);
    }

    @Override
    public ChildMap<RESULT> handleAsAncestorOfChild(String childPath, T child) {
        this.handler.handleAsAncestorOfChild(childPath, child);
        return this.withRemovedChild();
    }

    @Override
    public ChildMap<RESULT> handleExactMatchWithChild(T child) {
        this.handler.handleExactMatchWithChild(child);
        return this.withRemovedChild();
    }

    @Override
    public ChildMap<RESULT> handleUnrelatedToAnyChild() {
        this.handler.handleUnrelatedToAnyChild();
        return this.getChildMap();
    }
}

