/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.prebuilt;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeLibraryBinary;
import org.gradle.nativeplatform.PrebuiltLibrary;
import org.gradle.nativeplatform.internal.prebuilt.DefaultPrebuiltSharedLibraryBinary;
import org.gradle.nativeplatform.internal.prebuilt.DefaultPrebuiltStaticLibraryBinary;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatforms;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultBinaryNamingScheme;

public class PrebuiltLibraryInitializer
implements Action<PrebuiltLibrary> {
    private final Instantiator instantiator;
    private final FileCollectionFactory fileCollectionFactory;
    private final Set<NativePlatform> allPlatforms = new LinkedHashSet<NativePlatform>();
    private final Set<BuildType> allBuildTypes = new LinkedHashSet<BuildType>();
    private final Set<Flavor> allFlavors = new LinkedHashSet<Flavor>();

    public PrebuiltLibraryInitializer(Instantiator instantiator, FileCollectionFactory fileCollectionFactory, NativePlatforms nativePlatforms, Collection<? extends NativePlatform> allPlatforms, Collection<? extends BuildType> allBuildTypes, Collection<? extends Flavor> allFlavors) {
        this.instantiator = instantiator;
        this.fileCollectionFactory = fileCollectionFactory;
        this.allPlatforms.addAll(allPlatforms);
        this.allPlatforms.addAll(nativePlatforms.defaultPlatformDefinitions());
        this.allBuildTypes.addAll(allBuildTypes);
        this.allFlavors.addAll(allFlavors);
    }

    public void execute(PrebuiltLibrary prebuiltLibrary) {
        for (NativePlatform platform : this.allPlatforms) {
            for (BuildType buildType : this.allBuildTypes) {
                for (Flavor flavor : this.allFlavors) {
                    this.createNativeBinaries(prebuiltLibrary, platform, buildType, flavor, this.fileCollectionFactory);
                }
            }
        }
    }

    public void createNativeBinaries(PrebuiltLibrary library, NativePlatform platform, BuildType buildType, Flavor flavor, FileCollectionFactory fileCollectionFactory) {
        this.createNativeBinary(DefaultPrebuiltSharedLibraryBinary.class, "shared", library, platform, buildType, flavor, fileCollectionFactory);
        this.createNativeBinary(DefaultPrebuiltStaticLibraryBinary.class, "static", library, platform, buildType, flavor, fileCollectionFactory);
    }

    public <T extends NativeLibraryBinary> void createNativeBinary(Class<T> type, String typeName, PrebuiltLibrary library, NativePlatform platform, BuildType buildType, Flavor flavor, FileCollectionFactory fileCollectionFactory) {
        String name = this.getName(typeName, library, platform, buildType, flavor);
        NativeLibraryBinary nativeBinary = (NativeLibraryBinary)this.instantiator.newInstance(type, new Object[]{name, library, buildType, platform, flavor, fileCollectionFactory});
        library.getBinaries().add((Object)nativeBinary);
    }

    private String getName(String typeName, PrebuiltLibrary library, NativePlatform platform, BuildType buildType, Flavor flavor) {
        BinaryNamingScheme namingScheme = DefaultBinaryNamingScheme.component((String)library.getName()).withBinaryType(typeName).withVariantDimension(platform.getName()).withVariantDimension(buildType.getName()).withVariantDimension(flavor.getName());
        return namingScheme.getBinaryName();
    }
}

