/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.IndexDiff;

public class Status {
    private final IndexDiff diff;
    private final boolean clean;
    private final boolean hasUncommittedChanges;

    public Status(IndexDiff diff) {
        this.diff = diff;
        this.hasUncommittedChanges = !diff.getAdded().isEmpty() || !diff.getChanged().isEmpty() || !diff.getRemoved().isEmpty() || !diff.getMissing().isEmpty() || !diff.getModified().isEmpty() || !diff.getConflicting().isEmpty();
        this.clean = !this.hasUncommittedChanges && diff.getUntracked().isEmpty();
    }

    public boolean isClean() {
        return this.clean;
    }

    public boolean hasUncommittedChanges() {
        return this.hasUncommittedChanges;
    }

    public Set<String> getAdded() {
        return Collections.unmodifiableSet(this.diff.getAdded());
    }

    public Set<String> getChanged() {
        return Collections.unmodifiableSet(this.diff.getChanged());
    }

    public Set<String> getRemoved() {
        return Collections.unmodifiableSet(this.diff.getRemoved());
    }

    public Set<String> getMissing() {
        return Collections.unmodifiableSet(this.diff.getMissing());
    }

    public Set<String> getModified() {
        return Collections.unmodifiableSet(this.diff.getModified());
    }

    public Set<String> getUntracked() {
        return Collections.unmodifiableSet(this.diff.getUntracked());
    }

    public Set<String> getUntrackedFolders() {
        return Collections.unmodifiableSet(this.diff.getUntrackedFolders());
    }

    public Set<String> getConflicting() {
        return Collections.unmodifiableSet(this.diff.getConflicting());
    }

    public Map<String, IndexDiff.StageState> getConflictingStageState() {
        return Collections.unmodifiableMap(this.diff.getConflictingStageStates());
    }

    public Set<String> getIgnoredNotInIndex() {
        return Collections.unmodifiableSet(this.diff.getIgnoredNotInIndex());
    }

    public Set<String> getUncommittedChanges() {
        HashSet<String> uncommittedChanges = new HashSet<String>();
        uncommittedChanges.addAll(this.diff.getAdded());
        uncommittedChanges.addAll(this.diff.getChanged());
        uncommittedChanges.addAll(this.diff.getRemoved());
        uncommittedChanges.addAll(this.diff.getMissing());
        uncommittedChanges.addAll(this.diff.getModified());
        uncommittedChanges.addAll(this.diff.getConflicting());
        return uncommittedChanges;
    }
}

