/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

class TypeFilteringNotationConverter<N, S, T>
implements NotationConverter<N, T> {
    private final Class<S> type;
    private final NotationConverter<? super S, ? extends T> delegate;

    public TypeFilteringNotationConverter(Class<S> type, NotationConverter<? super S, ? extends T> delegate) {
        this.type = type;
        this.delegate = delegate;
    }

    @Override
    public void convert(N notation, NotationConvertResult<? super T> result) throws TypeConversionException {
        if (this.type.isInstance(notation)) {
            this.delegate.convert(this.type.cast(notation), result);
        }
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        this.delegate.describe(visitor);
    }
}

