/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.io.opentelemetry.api.internal;

import java.util.Arrays;

public final class OtelEncodingUtils {
    private static final char[] ENCODING = OtelEncodingUtils.buildEncodingArray();
    private static final byte[] DECODING = OtelEncodingUtils.buildDecodingArray();
    private static final boolean[] VALID_HEX = OtelEncodingUtils.buildValidHexArray();

    private static char[] buildEncodingArray() {
        char[] encoding = new char[512];
        for (int i2 = 0; i2 < 256; ++i2) {
            encoding[i2] = "0123456789abcdef".charAt(i2 >>> 4);
            encoding[i2 | 0x100] = "0123456789abcdef".charAt(i2 & 0xF);
        }
        return encoding;
    }

    private static byte[] buildDecodingArray() {
        byte[] decoding = new byte[128];
        Arrays.fill(decoding, (byte)-1);
        for (int i2 = 0; i2 < "0123456789abcdef".length(); ++i2) {
            char c2 = "0123456789abcdef".charAt(i2);
            decoding[c2] = (byte)i2;
        }
        return decoding;
    }

    private static boolean[] buildValidHexArray() {
        boolean[] validHex = new boolean[65535];
        for (int i2 = 0; i2 < 65535; ++i2) {
            validHex[i2] = 48 <= i2 && i2 <= 57 || 97 <= i2 && i2 <= 102;
        }
        return validHex;
    }

    public static void byteToBase16(byte value2, char[] dest, int destOffset) {
        int b2 = value2 & 0xFF;
        dest[destOffset] = ENCODING[b2];
        dest[destOffset + 1] = ENCODING[b2 | 0x100];
    }
}

