/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.inject.Inject;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.InMemoryInterner;
import org.gradle.internal.model.InMemoryLoadingCache;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.work.WorkerLimits;

@ServiceScope(value={Scope.BuildSession.class})
public class InMemoryCacheFactory {
    private final WorkerLimits workerLimits;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    @Inject
    public InMemoryCacheFactory(WorkerLimits workerLimits, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.workerLimits = workerLimits;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    public <K, V> InMemoryLoadingCache<K, V> create(Function<K, V> loader) {
        return new DefaultLoadingCache<K, V>(this.workerLimits.getMaxWorkerCount(), loader);
    }

    public <K, V> InMemoryLoadingCache<K, V> createIdentityCache(Function<K, V> loader) {
        return new IdentityLoadingCache<K, V>(this.workerLimits.getMaxWorkerCount(), loader);
    }

    public <K, V> InMemoryLoadingCache<K, V> createCalculatedValueCache(DisplayName type, Function<K, V> loader) {
        return new CalculatedValueCache<K, V>(type, this.calculatedValueContainerFactory, this.workerLimits.getMaxWorkerCount(), loader);
    }

    public <T> InMemoryInterner<T> createInterner() {
        return new DefaultInterner(this.workerLimits.getMaxWorkerCount());
    }

    private static class DefaultLoadingCache<K, V>
    implements InMemoryLoadingCache<K, V> {
        private final Map<K, V> delegate;
        private final Function<K, V> loader;

        public DefaultLoadingCache(int maxConcurrency, Function<K, V> loader) {
            this.delegate = new ConcurrentHashMap(maxConcurrency);
            this.loader = loader;
        }

        @Override
        public V get(K key) {
            V value = this.delegate.get(key);
            if (value != null) {
                return value;
            }
            return this.delegate.computeIfAbsent(key, this.loader);
        }

        @Override
        public void invalidate() {
            this.delegate.clear();
        }
    }

    private static class IdentityLoadingCache<K, V>
    implements InMemoryLoadingCache<K, V> {
        private final InMemoryLoadingCache<IdentityKey<K>, V> delegate;

        public IdentityLoadingCache(int maxConcurrency, Function<K, V> loader) {
            this.delegate = new DefaultLoadingCache<IdentityKey, Object>(maxConcurrency, key -> loader.apply(((IdentityKey)key).value));
        }

        @Override
        public V get(K key) {
            return this.delegate.get(new IdentityKey(key));
        }

        @Override
        public void invalidate() {
            this.delegate.invalidate();
        }
    }

    private static class CalculatedValueCache<K, V>
    implements InMemoryLoadingCache<K, V> {
        private final InMemoryLoadingCache<K, CalculatedValue<V>> delegate;

        public CalculatedValueCache(DisplayName type, CalculatedValueContainerFactory calculatedValueContainerFactory, int maxConcurrency, Function<K, V> loader) {
            this.delegate = new DefaultLoadingCache<Object, CalculatedValue>(maxConcurrency, key -> calculatedValueContainerFactory.create(Describables.of((Object)key, (Object)type), context -> loader.apply(key)));
        }

        @Override
        public V get(K key) {
            CalculatedValue<V> calculatedValue = this.delegate.get(key);
            calculatedValue.finalizeIfNotAlready();
            return (V)calculatedValue.get();
        }

        @Override
        public void invalidate() {
            this.delegate.invalidate();
        }
    }

    private static class DefaultInterner<T>
    implements InMemoryInterner<T> {
        private final DefaultLoadingCache<T, T> delegate;

        public DefaultInterner(int maxConcurrency) {
            this.delegate = new DefaultLoadingCache(maxConcurrency, Function.identity());
        }

        @Override
        public T intern(T value) {
            return this.delegate.get(value);
        }

        @Override
        public void invalidate() {
            this.delegate.invalidate();
        }
    }

    private static class IdentityKey<T> {
        private final T value;

        private IdentityKey(T value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            return ((IdentityKey)obj).value == this.value;
        }

        public int hashCode() {
            return System.identityHashCode(this.value);
        }
    }
}

