/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal.xcodeproj;

import com.dd.plist.NSArray;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import java.util.ArrayList;
import java.util.List;
import org.gradle.ide.xcode.internal.xcodeproj.PBXBuildPhase;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import org.jspecify.annotations.Nullable;

public class PBXShellScriptBuildPhase
extends PBXBuildPhase {
    private List<String> inputPaths = new ArrayList<String>();
    private List<String> outputPaths = new ArrayList<String>();
    private @Nullable String shellPath;
    private @Nullable String shellScript;
    private static final NSString DEFAULT_SHELL_PATH = new NSString("/bin/sh");
    private static final NSString DEFAULT_SHELL_SCRIPT = new NSString("");

    @Override
    public String isa() {
        return "PBXShellScriptBuildPhase";
    }

    public List<String> getInputPaths() {
        return this.inputPaths;
    }

    public List<String> getOutputPaths() {
        return this.outputPaths;
    }

    public @Nullable String getShellPath() {
        return this.shellPath;
    }

    public void setShellPath(String shellPath) {
        this.shellPath = shellPath;
    }

    public @Nullable String getShellScript() {
        return this.shellScript;
    }

    public void setShellScript(String shellScript) {
        this.shellScript = shellScript;
    }

    @Override
    public void serializeInto(XcodeprojSerializer s) {
        super.serializeInto(s);
        NSArray inputPathsArray = new NSArray(this.inputPaths.size());
        for (int i = 0; i < this.inputPaths.size(); ++i) {
            inputPathsArray.setValue(i, (Object)new NSString(this.inputPaths.get(i)));
        }
        s.addField("inputPaths", (NSObject)inputPathsArray);
        NSArray outputPathsArray = new NSArray(this.outputPaths.size());
        for (int i = 0; i < this.outputPaths.size(); ++i) {
            outputPathsArray.setValue(i, (Object)new NSString(this.outputPaths.get(i)));
        }
        s.addField("outputPaths", (NSObject)outputPathsArray);
        NSString shellPathString = this.shellPath == null ? DEFAULT_SHELL_PATH : new NSString(this.shellPath);
        s.addField("shellPath", (NSObject)shellPathString);
        NSString shellScriptString = this.shellScript == null ? DEFAULT_SHELL_SCRIPT : new NSString(this.shellScript);
        s.addField("shellScript", (NSObject)shellScriptString);
    }
}

