/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.maven;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.NamedVariantIdentifier;
import org.gradle.api.internal.artifacts.capability.CapabilitySelectorSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.IvyArtifactNameSerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractRealisedModuleResolveMetadataSerializationHelper;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.ExternalDependencyDescriptor;
import org.gradle.internal.component.external.model.ForcedDependencyMetadataWrapper;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.LazyToRealisedModuleComponentResolveMetadataHelper;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.RealisedConfigurationMetadata;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.MavenDependencyMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyType;
import org.gradle.internal.component.external.model.maven.RealisedMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.VariantIdentifier;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class RealisedMavenModuleResolveMetadataSerializationHelper
extends AbstractRealisedModuleResolveMetadataSerializationHelper {
    public RealisedMavenModuleResolveMetadataSerializationHelper(AttributeContainerSerializer attributeContainerSerializer, CapabilitySelectorSerializer capabilitySelectorSerializer, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        super(attributeContainerSerializer, capabilitySelectorSerializer, moduleIdentifierFactory);
    }

    @Override
    public void writeRealisedConfigurationsData(Encoder encoder, AbstractRealisedModuleComponentResolveMetadata transformed, Map<ExternalDependencyDescriptor, Integer> deduplicationDependencyCache) throws IOException {
        super.writeRealisedConfigurationsData(encoder, transformed, deduplicationDependencyCache);
        if (transformed instanceof RealisedMavenModuleResolveMetadata) {
            this.writeDerivedVariants(encoder, (RealisedMavenModuleResolveMetadata)transformed, deduplicationDependencyCache);
        }
    }

    public ModuleComponentResolveMetadata readMetadata(Decoder decoder, DefaultMavenModuleResolveMetadata resolveMetadata, Map<Integer, MavenDependencyDescriptor> deduplicationDependencyCache) throws IOException {
        Map<String, List<GradleDependencyMetadata>> variantToDependencies = this.readVariantDependencies(decoder);
        ImmutableList variants = resolveMetadata.getVariants();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ComponentVariant variant : variants) {
            builder.add((Object)new AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl(resolveMetadata.getId(), variant.getName(), variant.getAttributes().asImmutable(), variant.getDependencies(), variant.getDependencyConstraints(), variant.getFiles(), variant.getCapabilities(), variantToDependencies.get(variant.getName()), variant.isExternalVariant()));
        }
        ImmutableList realisedVariants = builder.build();
        Map<String, ModuleConfigurationMetadata> configurations = this.readMavenConfigurations(decoder, resolveMetadata, deduplicationDependencyCache);
        ImmutableList<ModuleConfigurationMetadata> derivedVariants = this.readDerivedVariants(decoder, resolveMetadata, deduplicationDependencyCache);
        return new RealisedMavenModuleResolveMetadata(resolveMetadata, (ImmutableList<? extends ComponentVariant>)realisedVariants, (List<ModuleConfigurationMetadata>)derivedVariants, configurations);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeDependencies(Encoder encoder, ConfigurationMetadata configuration, Map<ExternalDependencyDescriptor, Integer> deduplicationDependencyCache) throws IOException {
        List<? extends DependencyMetadata> dependencies = configuration.getDependencies();
        encoder.writeSmallInt(dependencies.size());
        for (DependencyMetadata dependencyMetadata : dependencies) {
            void var6_6;
            if (dependencyMetadata instanceof ForcedDependencyMetadataWrapper) {
                ForcedDependencyMetadataWrapper wrapper = (ForcedDependencyMetadataWrapper)dependencyMetadata;
                ModuleDependencyMetadata moduleDependencyMetadata = wrapper.unwrap();
                if (wrapper.isForce()) {
                    encoder.writeByte((byte)4);
                }
            }
            if (var6_6 instanceof GradleDependencyMetadata) {
                encoder.writeByte((byte)1);
                this.writeDependencyMetadata(encoder, (GradleDependencyMetadata)var6_6);
                continue;
            }
            if (var6_6 instanceof MavenDependencyMetadata) {
                MavenDependencyMetadata dependencyMetadata2 = (MavenDependencyMetadata)var6_6;
                MavenDependencyDescriptor dependencyDescriptor = dependencyMetadata2.getDependencyDescriptor();
                encoder.writeByte((byte)2);
                this.writeMavenDependency(encoder, dependencyDescriptor, deduplicationDependencyCache);
                encoder.writeNullableString((CharSequence)var6_6.getReason());
                continue;
            }
            throw new IllegalStateException("Unknown type of dependency: " + var6_6.getClass());
        }
    }

    private void writeDerivedVariants(Encoder encoder, RealisedMavenModuleResolveMetadata metadata, Map<ExternalDependencyDescriptor, Integer> deduplicationDependencyCache) throws IOException {
        ImmutableList<? extends ModuleConfigurationMetadata> derivedVariants = metadata.getDerivedVariants();
        encoder.writeSmallInt(derivedVariants.size());
        for (ConfigurationMetadata derivedVariant : derivedVariants) {
            this.writeConfiguration(encoder, derivedVariant);
            this.writeFiles(encoder, derivedVariant.getArtifacts());
            this.writeDerivedVariantExtra(encoder, derivedVariant, deduplicationDependencyCache);
        }
    }

    private void writeDerivedVariantExtra(Encoder encoder, ConfigurationMetadata derivedVariant, Map<ExternalDependencyDescriptor, Integer> deduplicationDependencyCache) throws IOException {
        encoder.writeBoolean(derivedVariant.isTransitive());
        encoder.writeBoolean(derivedVariant.isVisible());
        this.writeStringSet(encoder, (Set<String>)derivedVariant.getHierarchy());
        this.writeMavenExcludeRules(encoder, (List<ExcludeMetadata>)derivedVariant.getExcludes());
        this.writeDependencies(encoder, derivedVariant, deduplicationDependencyCache);
    }

    private Map<String, ModuleConfigurationMetadata> readMavenConfigurations(Decoder decoder, DefaultMavenModuleResolveMetadata metadata, Map<Integer, MavenDependencyDescriptor> deduplicationDependencyCache) throws IOException {
        ImmutableMap<String, Configuration> configurationDefinitions = metadata.getConfigurationDefinitions();
        int configurationsCount = decoder.readSmallInt();
        HashMap configurations = Maps.newHashMapWithExpectedSize((int)configurationsCount);
        for (int i = 0; i < configurationsCount; ++i) {
            String configurationName = decoder.readString();
            Configuration configuration = (Configuration)configurationDefinitions.get((Object)configurationName);
            ImmutableSet<String> hierarchy = LazyToRealisedModuleComponentResolveMetadataHelper.constructHierarchy(configuration, configurationDefinitions);
            ImmutableAttributes attributes = this.getAttributeContainerSerializer().read(decoder);
            ImmutableCapabilities capabilities = RealisedMavenModuleResolveMetadataSerializationHelper.readCapabilities(decoder);
            boolean isExternalVariant = decoder.readBoolean();
            ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts = this.readFiles(decoder, metadata.getId());
            NamedVariantIdentifier id = new NamedVariantIdentifier((ComponentIdentifier)metadata.getId(), configurationName);
            RealisedConfigurationMetadata configurationMetadata = new RealisedConfigurationMetadata(configurationName, (VariantIdentifier)id, metadata.getId(), configuration.isTransitive(), configuration.isVisible(), hierarchy, artifacts, (ImmutableList<ExcludeMetadata>)ImmutableList.of(), attributes, capabilities, false, isExternalVariant);
            ImmutableList<ModuleDependencyMetadata> dependencies = this.readDependencies(decoder, deduplicationDependencyCache);
            configurationMetadata.setDependencies((List<ModuleDependencyMetadata>)dependencies);
            configurations.put(configurationName, configurationMetadata);
        }
        return configurations;
    }

    private ImmutableList<ModuleDependencyMetadata> readDependencies(Decoder decoder, Map<Integer, MavenDependencyDescriptor> deduplicationDependencyCache) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        int dependenciesCount = decoder.readSmallInt();
        if (dependenciesCount == 0) {
            return ImmutableList.of();
        }
        for (int j = 0; j < dependenciesCount; ++j) {
            ModuleDependencyMetadata md;
            byte dependencyType = decoder.readByte();
            boolean force = false;
            if (dependencyType == 4) {
                force = true;
                dependencyType = decoder.readByte();
            }
            switch (dependencyType) {
                case 1: {
                    md = this.readDependencyMetadata(decoder);
                    break;
                }
                case 2: {
                    MavenDependencyDescriptor mavenDependencyDescriptor = this.readMavenDependency(decoder, deduplicationDependencyCache);
                    String reason = decoder.readNullableString();
                    md = new MavenDependencyMetadata(mavenDependencyDescriptor, reason, false);
                    break;
                }
                case 3: {
                    throw new IllegalStateException("Unexpected Ivy dependency for Maven module");
                }
                default: {
                    throw new IllegalStateException("Unknown dependency type " + dependencyType);
                }
            }
            if (force) {
                md = new ForcedDependencyMetadataWrapper(md);
            }
            builder.add((Object)md);
        }
        return builder.build();
    }

    private ImmutableList<ModuleConfigurationMetadata> readDerivedVariants(Decoder decoder, DefaultMavenModuleResolveMetadata resolveMetadata, Map<Integer, MavenDependencyDescriptor> deduplicationDependencyCache) throws IOException {
        int derivedVariantsCount = decoder.readSmallInt();
        if (derivedVariantsCount == 0) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < derivedVariantsCount; ++i) {
            builder.add((Object)this.readDerivedVariant(decoder, resolveMetadata, deduplicationDependencyCache));
        }
        return builder.build();
    }

    private ModuleConfigurationMetadata readDerivedVariant(Decoder decoder, DefaultMavenModuleResolveMetadata resolveMetadata, Map<Integer, MavenDependencyDescriptor> deduplicationDependencyCache) throws IOException {
        String name = decoder.readString();
        ImmutableAttributes attributes = this.attributeContainerSerializer.read(decoder);
        ImmutableCapabilities immutableCapabilities = RealisedMavenModuleResolveMetadataSerializationHelper.readCapabilities(decoder);
        boolean isExternalVariant = decoder.readBoolean();
        ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts = this.readFiles(decoder, resolveMetadata.getId());
        boolean transitive = decoder.readBoolean();
        boolean visible = decoder.readBoolean();
        ImmutableSet hierarchy = ImmutableSet.copyOf(this.readStringSet(decoder));
        List<ExcludeMetadata> excludeMetadata = this.readMavenExcludes(decoder);
        NamedVariantIdentifier id = new NamedVariantIdentifier((ComponentIdentifier)resolveMetadata.getId(), name);
        RealisedConfigurationMetadata realized = new RealisedConfigurationMetadata(name, (VariantIdentifier)id, resolveMetadata.getId(), transitive, visible, (ImmutableSet<String>)hierarchy, artifacts, (ImmutableList<ExcludeMetadata>)ImmutableList.copyOf(excludeMetadata), attributes, immutableCapabilities, false, isExternalVariant);
        ImmutableList<ModuleDependencyMetadata> dependencies = this.readDependencies(decoder, deduplicationDependencyCache);
        realized.setDependencies((List<ModuleDependencyMetadata>)dependencies);
        return realized;
    }

    private MavenDependencyDescriptor readMavenDependency(Decoder decoder, Map<Integer, MavenDependencyDescriptor> deduplicationDependencyCache) throws IOException {
        int mapping = decoder.readSmallInt();
        if (mapping == deduplicationDependencyCache.size()) {
            ModuleComponentSelector requested = this.getComponentSelectorSerializer().read(decoder);
            IvyArtifactName artifactName = IvyArtifactNameSerializer.INSTANCE.readNullable(decoder);
            List<ExcludeMetadata> mavenExcludes = this.readMavenExcludes(decoder);
            MavenScope scope = MavenScope.values()[decoder.readSmallInt()];
            MavenDependencyType type = MavenDependencyType.values()[decoder.readSmallInt()];
            MavenDependencyDescriptor mavenDependencyDescriptor = new MavenDependencyDescriptor(scope, type, requested, artifactName, mavenExcludes);
            deduplicationDependencyCache.put(mapping, mavenDependencyDescriptor);
            return mavenDependencyDescriptor;
        }
        MavenDependencyDescriptor mavenDependencyDescriptor = deduplicationDependencyCache.get(mapping);
        assert (mavenDependencyDescriptor != null);
        return mavenDependencyDescriptor;
    }

    private void writeMavenDependency(Encoder encoder, MavenDependencyDescriptor mavenDependency, Map<ExternalDependencyDescriptor, Integer> deduplicationDependencyCache) throws IOException {
        int nextMapping = deduplicationDependencyCache.size();
        Integer mapping = deduplicationDependencyCache.putIfAbsent(mavenDependency, nextMapping);
        if (mapping != null) {
            encoder.writeSmallInt(mapping.intValue());
        } else {
            encoder.writeSmallInt(nextMapping);
            this.getComponentSelectorSerializer().write(encoder, mavenDependency.getSelector());
            IvyArtifactNameSerializer.INSTANCE.writeNullable(encoder, mavenDependency.getDependencyArtifact());
            this.writeMavenExcludeRules(encoder, mavenDependency.getAllExcludes());
            encoder.writeSmallInt(mavenDependency.getScope().ordinal());
            encoder.writeSmallInt(mavenDependency.getType().ordinal());
        }
    }
}

