/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.jline.reader.impl;

import java.util.ListIterator;
import org.jetbrains.kotlin.org.jline.reader.Expander;
import org.jetbrains.kotlin.org.jline.reader.History;

public class DefaultExpander
implements Expander {
    @Override
    public String expandHistory(History history, String line) {
        boolean inQuote = false;
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        int unicode = 0;
        block16: for (int i2 = 0; i2 < line.length(); ++i2) {
            char c2 = line.charAt(i2);
            if (unicode > 0) {
                escaped = --unicode >= 0;
                sb.append(c2);
                continue;
            }
            if (escaped) {
                if (c2 == 'u') {
                    unicode = 4;
                } else {
                    escaped = false;
                }
                sb.append(c2);
                continue;
            }
            if (c2 == '\'') {
                inQuote = !inQuote;
                sb.append(c2);
                continue;
            }
            if (inQuote) {
                sb.append(c2);
                continue;
            }
            switch (c2) {
                case '\\': {
                    escaped = true;
                    sb.append(c2);
                    continue block16;
                }
                case '!': {
                    if (i2 + 1 < line.length()) {
                        c2 = line.charAt(++i2);
                        boolean neg = false;
                        String rep = null;
                        switch (c2) {
                            case '!': {
                                if (history.size() == 0) {
                                    throw new IllegalArgumentException("!!: event not found");
                                }
                                rep = history.get(history.index() - 1);
                                break;
                            }
                            case '#': {
                                sb.append(sb.toString());
                                break;
                            }
                            case '?': {
                                int i1 = line.indexOf(63, i2 + 1);
                                if (i1 < 0) {
                                    i1 = line.length();
                                }
                                String sc = line.substring(i2 + 1, i1);
                                i2 = i1;
                                int idx = this.searchBackwards(history, sc, history.index(), false);
                                if (idx < 0) {
                                    throw new IllegalArgumentException("!?" + sc + ": event not found");
                                }
                                rep = history.get(idx);
                                break;
                            }
                            case '$': {
                                if (history.size() == 0) {
                                    throw new IllegalArgumentException("!$: event not found");
                                }
                                String previous = history.get(history.index() - 1).trim();
                                int lastSpace = previous.lastIndexOf(32);
                                if (lastSpace != -1) {
                                    rep = previous.substring(lastSpace + 1);
                                    break;
                                }
                                rep = previous;
                                break;
                            }
                            case '\t': 
                            case ' ': {
                                sb.append('!');
                                sb.append(c2);
                                break;
                            }
                            case '-': {
                                neg = true;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                int idx;
                                int i1 = ++i2;
                                while (i2 < line.length() && (c2 = line.charAt(i2)) >= '0' && c2 <= '9') {
                                    ++i2;
                                }
                                try {
                                    idx = Integer.parseInt(line.substring(i1, i2));
                                }
                                catch (NumberFormatException e2) {
                                    throw new IllegalArgumentException((neg ? "!-" : "!") + line.substring(i1, i2) + ": event not found");
                                }
                                if (neg && idx > 0 && idx <= history.size()) {
                                    rep = history.get(history.index() - idx);
                                    break;
                                }
                                if (!neg && idx > history.index() - history.size() && idx <= history.index()) {
                                    rep = history.get(idx - 1);
                                    break;
                                }
                                throw new IllegalArgumentException((neg ? "!-" : "!") + line.substring(i1, i2) + ": event not found");
                            }
                            default: {
                                String ss = line.substring(i2);
                                i2 = line.length();
                                int idx = this.searchBackwards(history, ss, history.index(), true);
                                if (idx < 0) {
                                    throw new IllegalArgumentException("!" + ss + ": event not found");
                                }
                                rep = history.get(idx);
                            }
                        }
                        if (rep == null) continue block16;
                        sb.append(rep);
                        continue block16;
                    }
                    sb.append(c2);
                    continue block16;
                }
                case '^': {
                    if (i2 == 0) {
                        int i1 = line.indexOf(94, i2 + 1);
                        int i22 = line.indexOf(94, i1 + 1);
                        if (i22 < 0) {
                            i22 = line.length();
                        }
                        if (i1 > 0 && i22 > 0) {
                            String s1 = line.substring(i2 + 1, i1);
                            String s2 = line.substring(i1 + 1, i22);
                            String s3 = history.get(history.index() - 1).replace(s1, s2);
                            sb.append(s3);
                            i2 = i22 + 1;
                            continue block16;
                        }
                    }
                    sb.append(c2);
                    continue block16;
                }
                default: {
                    sb.append(c2);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String expandVar(String word) {
        return word;
    }

    protected int searchBackwards(History history, String searchTerm, int startIndex, boolean startsWith) {
        ListIterator<History.Entry> it = history.iterator(startIndex);
        while (it.hasPrevious()) {
            History.Entry e2 = it.previous();
            if (!(startsWith ? e2.line().startsWith(searchTerm) : e2.line().contains(searchTerm))) continue;
            return e2.index();
        }
        return -1;
    }
}

