/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.prompts;

import net.rubygrapefruit.platform.prompts.Prompter;
import net.rubygrapefruit.platform.terminal.TerminalOutput;

class YesNoView {
    private final TerminalOutput output;
    private final String prompt;
    private final boolean defaultValue;

    YesNoView(TerminalOutput output, String prompt, boolean defaultValue) {
        this.output = output;
        this.prompt = prompt;
        this.defaultValue = defaultValue;
    }

    public void render() {
        this.output.newline();
        this.output.hideCursor();
        this.output.bold().write(this.prompt).normal().write(" [y/n]: ");
        this.output.dim().write(this.defaultValue ? "y" : "n").normal().cursorLeft(1);
        this.output.showCursor();
    }

    public void close(Boolean selected) {
        this.output.cursorStartOfLine();
        this.output.clearToEndOfLine();
        this.output.write(this.prompt).write(": ");
        if (selected != null) {
            this.output.foreground(Prompter.SELECTION_COLOR);
            this.output.write(selected != false ? "yes" : "no");
            this.output.reset();
        } else {
            this.output.write("<none>");
        }
        this.output.newline();
    }
}

