/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildconfiguration.tasks;

import org.gradle.platform.Architecture;
import org.gradle.platform.BuildPlatform;
import org.gradle.platform.BuildPlatformFactory;
import org.gradle.platform.OperatingSystem;

public class DaemonJvmPropertiesUtils {
    public static String getToolchainUrlPropertyForPlatform(BuildPlatform buildPlatform) {
        String operatingSystemName = buildPlatform.getOperatingSystem().name();
        String architectureName = buildPlatform.getArchitecture().name();
        return String.format("toolchainUrl.%s.%s", operatingSystemName, architectureName);
    }

    public static BuildPlatform getPlatformFromToolchainProperty(String toolchainUrlProperty) {
        String[] parts = toolchainUrlProperty.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException(String.format("Invalid toolchain URL property name: %s", toolchainUrlProperty));
        }
        return BuildPlatformFactory.of((Architecture)Architecture.valueOf((String)parts[2]), (OperatingSystem)OperatingSystem.valueOf((String)parts[1]));
    }
}

