plugins {
    id("gradlebuild.distribution.api-java")
}

description = """Basic testing related plugins, which establish conventions for testing output directories,
and setup basic testing-related features like a testSuites container and the testing extension.  It provides most of the
testing-related abstract base types and interfaces for things like Test tasks, listeners and filters.

This project is a implementation dependency of many other testing-related subprojects in the Gradle build.
"""

dependencies {
    api(projects.baseServices)
    api(projects.buildOperations)
    api(projects.core)
    api(projects.coreApi)
    api(projects.enterpriseLogging)
    api(projects.stdlibJavaExtensions)
    api(projects.loggingApi)
    api(projects.messaging)
    api(projects.native)
    api(projects.problemsApi)
    api(projects.reportRendering)
    api(projects.reporting)
    api(projects.serialization)
    api(projects.serviceProvider)
    api(projects.testingBaseInfrastructure)
    api(projects.time)

    api(libs.groovy)
    api(libs.guava)
    api(libs.jspecify)
    api(libs.inject)

    implementation(projects.logging)
    implementation(projects.baseServicesGroovy)
    implementation(projects.concurrent)
    implementation(projects.files)
    implementation(projects.modelCore)

    implementation(libs.commonsLang)
    implementation(libs.commonsIo)
    implementation(libs.kryo)
    implementation(libs.slf4jApi)

    testImplementation(projects.fileCollections)
    testImplementation(projects.enterpriseOperations)
    testImplementation(testFixtures(projects.baseServices))
    testImplementation(testFixtures(projects.core))
    testImplementation(testFixtures(projects.logging))
    testImplementation(testFixtures(projects.messaging))
    testImplementation(testFixtures(projects.platformBase))
    testImplementation(testFixtures(projects.serialization))
    testImplementation(testFixtures(projects.time))

    testImplementation(libs.commonsIo)

    testFixturesImplementation(projects.baseServices)
    testFixturesImplementation(projects.internalIntegTesting)
    testFixturesImplementation(projects.logging)
    testFixturesImplementation(projects.modelCore)

    testFixturesImplementation(libs.guava)
    testFixturesImplementation(libs.jsoup)

    testRuntimeOnly(projects.distributionsCore) {
        because("ProjectBuilder tests load services from a Gradle distribution.")
    }
    integTestDistributionRuntimeOnly(projects.distributionsCore)
}

strictCompile {
    ignoreRawTypes() // raw types used in public API (org.gradle.api.tasks.testing.AbstractTestTask)
}

packageCycles {
    excludePatterns.add("org/gradle/api/internal/tasks/testing/**")
}

tasks.isolatedProjectsIntegTest {
    enabled = false
}
