plugins {
    id("gradlebuild.distribution.api-java")
}

description = "Public and internal 'core' Gradle APIs with implementation"

configurations {
    register("reports")
}

tasks.classpathManifest {
    optionalProjects.add("gradle-kotlin-dsl")
    // The gradle-runtime-api-info.jar is added by a 'distributions-...' project if it is on the (integration test) runtime classpath.
    // It contains information services in ':core' need to reason about the complete Gradle distribution.
    // To allow parts of ':core' code to be instantiated in unit tests without relying on this functionality, the dependency is optional.
    optionalProjects.add("gradle-runtime-api-info")
}

// Instrumentation interceptors for tests
// Separated from the test source set since we don't support incremental annotation processor with Java/Groovy joint compilation
val testInterceptors = sourceSets.create("testInterceptors") {
    compileClasspath += sourceSets.main.get().output
    runtimeClasspath += sourceSets.main.get().output
}
sourceSets.test {
    compileClasspath += testInterceptors.output
    runtimeClasspath += testInterceptors.output
}
dependencyAnalysis {
    issues {
        ignoreSourceSet(testInterceptors.name)
    }
}
jvmCompile {
    addCompilationFrom(testInterceptors) {
        // By default, test interceptors compile to the same JVM version as the production code.
        targetJvmVersion = compilations.named("main").flatMap { it.targetJvmVersion }
    }
}

val testInterceptorsImplementation: Configuration by configurations.getting {
    extendsFrom(configurations.implementation.get())
}

errorprone {
    disabledChecks.addAll(
        "ModifyCollectionInEnhancedForLoop", // 1 occurrences
        "NonApiType", // 1 occurrences
        "NonCanonicalType", // 16 occurrences
        "ReferenceEquality", // 2 occurrences
        "StreamResourceLeak", // 6 occurrences
        "TypeParameterShadowing", // 1 occurrences
        "TypeParameterUnusedInFormals", // 2 occurrences
        "UndefinedEquals", // 1 occurrences
    )
}

dependencies {
    api(projects.baseAsm)
    api(projects.baseServices)
    api(projects.baseServicesGroovy)
    api(projects.buildCache)
    api(projects.buildCacheBase)
    api(projects.buildCacheLocal)
    api(projects.buildCachePackaging)
    api(projects.buildCacheSpi)
    api(projects.buildInitSpecs)
    api(projects.buildOperations)
    api(projects.buildOption)
    api(projects.buildProcessServices)
    api(projects.classloaders)
    api(projects.cli)
    api(projects.concurrent)
    api(projects.coreApi)
    api(projects.declarativeDslApi)
    api(projects.enterpriseLogging)
    api(projects.enterpriseOperations)
    api(projects.execution)
    api(projects.fileCollections)
    api(projects.fileOperations)
    api(projects.fileTemp)
    api(projects.fileWatching)
    api(projects.files)
    api(projects.functional)
    api(projects.hashing)
    api(projects.instrumentationAgentServices)
    api(projects.instrumentationReporting)
    api(projects.internalInstrumentationApi)
    api(projects.jvmServices)
    api(projects.logging)
    api(projects.loggingApi)
    api(projects.messaging)
    api(projects.modelCore)
    api(projects.modelReflect)
    api(projects.native)
    api(projects.normalizationJava)
    api(projects.persistentCache)
    api(projects.problemsApi)
    api(projects.processMemoryServices)
    api(projects.processServices)
    api(projects.requestHandlerWorker)
    api(projects.resources)
    api(projects.scopedPersistentCache)
    api(projects.serialization)
    api(projects.serviceLookup)
    api(projects.serviceProvider)
    api(projects.snapshots)
    api(projects.softwareFeatures)
    api(projects.stdlibJavaExtensions)
    api(projects.time)
    api(projects.versionedCache)
    api(projects.workerMain)

    api(libs.ant)
    api(libs.asm)
    api(libs.asmTree)
    api(libs.groovy)
    api(libs.guava)
    api(libs.inject)
    api(libs.jspecify)
    api(libs.jsr305)
    api(libs.nativePlatform)

    implementation(projects.buildOperationsTrace)
    implementation(projects.groovyLoader)
    implementation(projects.inputTracking)
    implementation(projects.io)
    implementation(projects.modelGroovy)
    implementation(projects.problemsRendering)
    implementation(projects.serviceRegistryBuilder)
    implementation(projects.softwareFeaturesApi)

    implementation(libs.asmCommons)
    implementation(libs.commonsCompress)
    implementation(libs.commonsIo)
    implementation(libs.commonsLang)
    implementation(libs.errorProneAnnotations)
    implementation(libs.fastutil)
    implementation(libs.groovyAnt)
    implementation(libs.groovyJson)
    implementation(libs.groovyXml)
    implementation(libs.slf4jApi)
    implementation(libs.tomlj) {
        // Used for its nullability annotations, not needed at runtime
        exclude("org.checkerframework", "checker-qual")
    }

    compileOnly(libs.kotlinStdlib) {
        because("it needs to forward calls from instrumented code to the Kotlin standard library")
    }

    // Libraries that are not used in this project but required in the distribution
    runtimeOnly(libs.groovyAstbuilder)
    runtimeOnly(libs.groovyDateUtil)
    runtimeOnly(libs.groovyDatetime)
    runtimeOnly(libs.groovyDoc)
    runtimeOnly(libs.groovyNio)

    testImplementation(projects.buildInit)
    testImplementation(projects.platformJvm)
    testImplementation(projects.platformNative)
    testImplementation(projects.testingBase)
    testImplementation(libs.jsoup)
    testImplementation(libs.log4jToSlf4j)
    testImplementation(libs.jclToSlf4j)

    testFixturesCompileOnly(libs.jetbrainsAnnotations)

    testFixturesApi(projects.baseServices) {
        because("test fixtures expose Action")
    }
    testFixturesApi(projects.baseServicesGroovy) {
        because("test fixtures expose AndSpec")
    }
    testFixturesApi(projects.coreApi) {
        because("test fixtures expose Task")
    }
    testFixturesApi(projects.logging) {
        because("test fixtures expose Logger")
    }
    testFixturesApi(projects.modelCore) {
        because("test fixtures expose IConventionAware")
    }
    testFixturesApi(projects.buildCache) {
        because("test fixtures expose BuildCacheController")
    }
    testFixturesApi(projects.execution) {
        because("test fixtures expose OutputChangeListener")
    }
    testFixturesApi(projects.native) {
        because("test fixtures expose FileSystem")
    }
    testFixturesApi(projects.fileCollections) {
        because("test fixtures expose file collection types")
    }
    testFixturesApi(projects.fileTemp) {
        because("test fixtures expose temp file types")
    }
    testFixturesApi(projects.resources) {
        because("test fixtures expose file resource types")
    }
    testFixturesApi(testFixtures(projects.buildOperations)) {
        because("test fixtures expose test build operations runner")
    }
    testFixturesApi(testFixtures(projects.persistentCache)) {
        because("test fixtures expose cross-build cache factory")
    }
    testFixturesApi(projects.processServices) {
        because("test fixtures expose exec handler types")
    }
    testFixturesApi(testFixtures(projects.hashing)) {
        because("test fixtures expose test hash codes")
    }
    testFixturesApi(testFixtures(projects.snapshots)) {
        because("test fixtures expose file snapshot related functionality")
    }
    testFixturesApi(testFixtures(projects.serviceRegistryImpl)) {
        because("test fixtures expose DefaultServiceRegistry")
    }
    testFixturesApi(projects.unitTestFixtures) {
        because("test fixtures expose ProjectBuilder")
    }
    testFixturesImplementation(projects.buildOption)
    testFixturesImplementation(projects.enterpriseOperations)
    testFixturesImplementation(projects.messaging)
    testFixturesImplementation(projects.normalizationJava)
    testFixturesImplementation(projects.persistentCache)
    testFixturesImplementation(projects.snapshots)
    testFixturesImplementation(libs.ant)
    testFixturesImplementation(libs.asm)
    testFixturesImplementation(libs.guava)
    testFixturesImplementation(projects.internalInstrumentationApi)
    testFixturesImplementation(libs.ivy)
    testFixturesImplementation(libs.slf4jApi)
    testFixturesImplementation(projects.dependencyManagement) {
        because("Used in VersionCatalogErrorMessages for org.gradle.api.internal.catalog.DefaultVersionCatalogBuilder.getExcludedNames")
    }

    testFixturesRuntimeOnly(projects.pluginUse) {
        because("This is a core extension module (see DynamicModulesClassPathProvider.GRADLE_EXTENSION_MODULES)")
    }
    testFixturesRuntimeOnly(projects.workers) {
        because("This is a core extension module (see DynamicModulesClassPathProvider.GRADLE_EXTENSION_MODULES)")
    }
    testFixturesRuntimeOnly(projects.compositeBuilds) {
        because("We always need a BuildStateRegistry service implementation")
    }

    testImplementation(projects.dependencyManagement)

    testImplementation(testFixtures(projects.serialization))
    testImplementation(testFixtures(projects.coreApi))
    testImplementation(testFixtures(projects.messaging))
    testImplementation(testFixtures(projects.modelCore))
    testImplementation(testFixtures(projects.modelReflect))
    testImplementation(testFixtures(projects.logging))
    testImplementation(testFixtures(projects.baseServices))
    testImplementation(testFixtures(projects.baseDiagnostics))
    testImplementation(testFixtures(projects.snapshots))
    testImplementation(testFixtures(projects.execution))
    testImplementation(testFixtures(projects.time))

    integTestImplementation(projects.workers)
    integTestImplementation(projects.dependencyManagement)
    integTestImplementation(projects.launcher)
    integTestImplementation(projects.war)
    integTestImplementation(projects.daemonServices)
    integTestImplementation(libs.jansi)
    integTestImplementation(libs.jetbrainsAnnotations)
    integTestImplementation(libs.jetty)
    integTestImplementation(libs.littleproxy)
    integTestImplementation(testFixtures(projects.native))
    integTestImplementation(testFixtures(projects.fileTemp))

    testRuntimeOnly(projects.distributionsCore) {
        because("This is required by ProjectBuilder, but ProjectBuilder cannot declare :distributions-core as a dependency due to conflicts with other distributions.")
    }

    integTestDistributionRuntimeOnly(projects.distributionsJvm) {
        because("Some tests utilise the 'java-gradle-plugin' and with that TestKit, some also use the 'war' plugin")
    }
    crossVersionTestDistributionRuntimeOnly(projects.distributionsCore)

    annotationProcessor(projects.internalInstrumentationProcessor)
    annotationProcessor(platform(projects.distributionsDependencies))

    testInterceptorsImplementation(platform(projects.distributionsDependencies))
    testInterceptorsImplementation(testFixtures(projects.core))
    "testInterceptorsAnnotationProcessor"(projects.internalInstrumentationProcessor)
    "testInterceptorsAnnotationProcessor"(platform(projects.distributionsDependencies))
}

strictCompile {
    ignoreRawTypes() // raw types used in public API
    ignoreAnnotationProcessing() // Without this, javac will complain about unclaimed annotations
}

packageCycles {
    excludePatterns.add("org/gradle/**")
}

tasks.test {
    setForkEvery(200)
}

tasks.compileTestGroovy {
    groovyOptions.isFork = true
    groovyOptions.forkOptions.run {
        memoryInitialSize = "128M"
        memoryMaximumSize = "1G"
    }
}

testFilesCleanup.reportOnly = true
