/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildtree;

import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.build.NestedBuildState;
import org.gradle.internal.buildtree.BuildTreeFinishExecutor;
import org.gradle.internal.exception.ExceptionAnalyser;
import org.jspecify.annotations.Nullable;

public class DefaultBuildTreeFinishExecutor
implements BuildTreeFinishExecutor {
    private final BuildStateRegistry buildStateRegistry;
    private final ExceptionAnalyser exceptionAnalyser;
    private final BuildLifecycleController buildLifecycleController;

    public DefaultBuildTreeFinishExecutor(BuildStateRegistry buildStateRegistry, ExceptionAnalyser exceptionAnalyser, BuildLifecycleController buildLifecycleController) {
        this.buildStateRegistry = buildStateRegistry;
        this.exceptionAnalyser = exceptionAnalyser;
        this.buildLifecycleController = buildLifecycleController;
    }

    @Override
    public @Nullable RuntimeException finishBuildTree(List<Throwable> failures) {
        ArrayList<Throwable> finishNestedBuildsFailures = new ArrayList<Throwable>(failures);
        this.buildStateRegistry.visitBuilds(buildState -> {
            if (buildState instanceof NestedBuildState) {
                ExecutionResult<Void> result = ((NestedBuildState)buildState).finishBuild();
                finishNestedBuildsFailures.addAll(result.getFailures());
            }
        });
        RuntimeException reportableFailure = this.exceptionAnalyser.transform(finishNestedBuildsFailures);
        ExecutionResult<Void> finishResult = this.buildLifecycleController.finishBuild(reportableFailure);
        ArrayList<Throwable> finishFailures = new ArrayList<Throwable>();
        if (reportableFailure != null) {
            finishFailures.add(reportableFailure);
        }
        finishFailures.addAll(finishResult.getFailures());
        boolean failed = reportableFailure != null;
        this.buildStateRegistry.visitBuilds(buildState -> {
            ExecutionResult<Void> result = buildState.beforeModelDiscarded(failed);
            finishFailures.addAll(result.getFailures());
        });
        return this.exceptionAnalyser.transform(finishFailures);
    }
}

