/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.plugin.software.internal.SoftwareFeatureApplicator;
import org.gradle.plugin.software.internal.SoftwareFeatureRegistry;

public class SoftwareFeatureSupportInternal {
    private static final String CONTEXT_EXTENSION_NAME = "$softwareFeatureContext";

    public static SoftwareFeatureContext getContext(ExtensionAware target) {
        return (SoftwareFeatureContext)target.getExtensions().getByName(CONTEXT_EXTENSION_NAME);
    }

    public static void registerContextIfAbsent(ExtensionAware target, SoftwareFeatureApplicator softwareFeatureApplicator, SoftwareFeatureRegistry softwareFeatureRegistry) {
        ExtensionContainer extensions = target.getExtensions();
        if (extensions.findByName(CONTEXT_EXTENSION_NAME) == null) {
            extensions.add(CONTEXT_EXTENSION_NAME, (Object)new DefaultSoftwareFeatureContext(softwareFeatureApplicator, softwareFeatureRegistry));
        }
    }

    public static interface SoftwareFeatureContext {
        public SoftwareFeatureApplicator getSoftwareFeatureApplicator();

        public SoftwareFeatureRegistry getSoftwareFeatureRegistry();
    }

    private static class DefaultSoftwareFeatureContext
    implements SoftwareFeatureContext {
        private final SoftwareFeatureApplicator softwareFeatureApplicator;
        private final SoftwareFeatureRegistry softwareFeatureRegistry;

        private DefaultSoftwareFeatureContext(SoftwareFeatureApplicator softwareFeatureApplicator, SoftwareFeatureRegistry softwareFeatureRegistry) {
            this.softwareFeatureApplicator = softwareFeatureApplicator;
            this.softwareFeatureRegistry = softwareFeatureRegistry;
        }

        @Override
        public SoftwareFeatureApplicator getSoftwareFeatureApplicator() {
            return this.softwareFeatureApplicator;
        }

        @Override
        public SoftwareFeatureRegistry getSoftwareFeatureRegistry() {
            return this.softwareFeatureRegistry;
        }
    }
}

