/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.CrossProjectModelAccess;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.TaskDependencyUsageTracker;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public class DefaultCrossProjectModelAccess
implements CrossProjectModelAccess {
    private final ProjectRegistry projectRegistry;

    public DefaultCrossProjectModelAccess(ProjectRegistry projectRegistry) {
        this.projectRegistry = projectRegistry;
    }

    @Override
    public ProjectInternal access(ProjectInternal referrer, ProjectInternal project) {
        return project;
    }

    @Override
    public @Nullable ProjectInternal findProject(ProjectInternal referrer, Path path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Project path must be absolute");
        }
        return this.projectRegistry.getProject(path.asString());
    }

    @Override
    public Map<String, Project> getChildProjects(ProjectInternal referrer, ProjectInternal target) {
        return target.getOwner().getChildProjects().stream().collect(Collectors.toMap(ProjectState::getName, projectState -> this.access(referrer, projectState.getMutableModel())));
    }

    @Override
    public Set<? extends ProjectInternal> getSubprojects(ProjectInternal referrer, ProjectInternal target) {
        return new TreeSet<ProjectInternal>(this.projectRegistry.getSubProjects(target.getPath()));
    }

    @Override
    public Set<? extends ProjectInternal> getAllprojects(ProjectInternal referrer, ProjectInternal target) {
        return new TreeSet<ProjectInternal>(this.projectRegistry.getAllProjects(target.getPath()));
    }

    @Override
    public GradleInternal gradleInstanceForProject(ProjectInternal referrerProject, GradleInternal gradle) {
        return gradle;
    }

    @Override
    public TaskDependencyUsageTracker taskDependencyUsageTracker(ProjectInternal referrerProject) {
        return null;
    }

    @Override
    public TaskExecutionGraphInternal taskGraphForProject(ProjectInternal referrerProject, TaskExecutionGraphInternal taskGraph) {
        return taskGraph;
    }

    @Override
    public DynamicObject parentProjectDynamicInheritedScope(ProjectInternal referrerProject) {
        ProjectInternal parent = referrerProject.getParent();
        return parent != null ? parent.getInheritedScope() : null;
    }
}

