/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.target;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.Architecture;
import org.jetbrains.kotlin.konan.target.BinaryFormat;
import org.jetbrains.kotlin.konan.target.Family;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.SanitizerKind;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\r*\u00020\u0002\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u001a"}, d2={"supportsGrandCentralDispatch", "", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getSupportsGrandCentralDispatch", "(Lorg/jetbrains/kotlin/konan/target/KonanTarget;)Z", "supportsSignposts", "getSupportsSignposts", "binaryFormat", "Lorg/jetbrains/kotlin/konan/target/BinaryFormat;", "hasFoundationFramework", "hasUIKitFramework", "needSmallBinary", "pointerBits", "", "supportedSanitizers", "", "Lorg/jetbrains/kotlin/konan/target/SanitizerKind;", "supports64BitAtomics", "supports64BitMulOverflow", "supportsCoreSymbolication", "supportsGccUnwind", "supportsIosCrashLog", "supportsLibBacktrace", "supportsObjcInterop", "supportsUnalignedAccess", "supportsWinAPIUnwind", "kotlin-native-utils"})
public final class KonanTargetExtenstionsKt {
    @NotNull
    public static final BinaryFormat binaryFormat(@NotNull KonanTarget $this$binaryFormat) {
        BinaryFormat binaryFormat;
        Intrinsics.checkNotNullParameter((Object)$this$binaryFormat, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$binaryFormat.getFamily().ordinal()]) {
            case 1: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 2: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 3: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 4: {
                binaryFormat = BinaryFormat.MACH_O;
                break;
            }
            case 5: {
                binaryFormat = BinaryFormat.ELF;
                break;
            }
            case 6: {
                binaryFormat = BinaryFormat.ELF;
                break;
            }
            case 7: {
                binaryFormat = BinaryFormat.PE_COFF;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return binaryFormat;
    }

    public static final int pointerBits(@NotNull KonanTarget $this$pointerBits) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)$this$pointerBits, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$pointerBits.getArchitecture().ordinal()]) {
            case 1: {
                n2 = 64;
                break;
            }
            case 2: {
                n2 = 32;
                break;
            }
            case 3: {
                if (Intrinsics.areEqual((Object)$this$pointerBits, (Object)KonanTarget.WATCHOS_ARM64.INSTANCE)) {
                    n2 = 32;
                    break;
                }
                n2 = 64;
                break;
            }
            case 4: {
                n2 = 32;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n2;
    }

    public static final boolean supportsLibBacktrace(@NotNull KonanTarget $this$supportsLibBacktrace) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsLibBacktrace, (String)"<this>");
        return $this$supportsLibBacktrace.getFamily().isAppleFamily() || $this$supportsLibBacktrace.getFamily() == Family.LINUX || $this$supportsLibBacktrace.getFamily() == Family.ANDROID;
    }

    public static final boolean supportsCoreSymbolication(@NotNull KonanTarget $this$supportsCoreSymbolication) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsCoreSymbolication, (String)"<this>");
        Object[] objectArray = new KonanTarget[]{KonanTarget.MACOS_X64.INSTANCE, KonanTarget.MACOS_ARM64.INSTANCE, KonanTarget.IOS_X64.INSTANCE, KonanTarget.IOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.TVOS_X64.INSTANCE, KonanTarget.TVOS_SIMULATOR_ARM64.INSTANCE, KonanTarget.WATCHOS_X64.INSTANCE, KonanTarget.WATCHOS_SIMULATOR_ARM64.INSTANCE};
        return CollectionsKt.listOf((Object[])objectArray).contains($this$supportsCoreSymbolication);
    }

    public static final boolean supportsGccUnwind(@NotNull KonanTarget $this$supportsGccUnwind) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsGccUnwind, (String)"<this>");
        return $this$supportsGccUnwind.getFamily() == Family.ANDROID || $this$supportsGccUnwind.getFamily() == Family.LINUX;
    }

    public static final boolean supportsWinAPIUnwind(@NotNull KonanTarget $this$supportsWinAPIUnwind) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsWinAPIUnwind, (String)"<this>");
        return $this$supportsWinAPIUnwind instanceof KonanTarget.MINGW_X64;
    }

    public static final boolean supportsObjcInterop(@NotNull KonanTarget $this$supportsObjcInterop) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsObjcInterop, (String)"<this>");
        return $this$supportsObjcInterop.getFamily().isAppleFamily();
    }

    public static final boolean hasFoundationFramework(@NotNull KonanTarget $this$hasFoundationFramework) {
        Intrinsics.checkNotNullParameter((Object)$this$hasFoundationFramework, (String)"<this>");
        return $this$hasFoundationFramework.getFamily().isAppleFamily();
    }

    public static final boolean hasUIKitFramework(@NotNull KonanTarget $this$hasUIKitFramework) {
        Intrinsics.checkNotNullParameter((Object)$this$hasUIKitFramework, (String)"<this>");
        return $this$hasUIKitFramework.getFamily() == Family.IOS || $this$hasUIKitFramework.getFamily() == Family.TVOS;
    }

    public static final boolean supports64BitMulOverflow(@NotNull KonanTarget $this$supports64BitMulOverflow) {
        Intrinsics.checkNotNullParameter((Object)$this$supports64BitMulOverflow, (String)"<this>");
        KonanTarget konanTarget = $this$supports64BitMulOverflow;
        return konanTarget instanceof KonanTarget.LINUX_ARM32_HFP ? false : (konanTarget instanceof KonanTarget.ANDROID_ARM32 ? false : !(konanTarget instanceof KonanTarget.ANDROID_X86));
    }

    public static final boolean supportsIosCrashLog(@NotNull KonanTarget $this$supportsIosCrashLog) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsIosCrashLog, (String)"<this>");
        KonanTarget konanTarget = $this$supportsIosCrashLog;
        return Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.IOS_ARM64.INSTANCE) ? true : (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.WATCHOS_ARM32.INSTANCE) ? true : (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.WATCHOS_ARM64.INSTANCE) ? true : Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.TVOS_ARM64.INSTANCE)));
    }

    public static final boolean supports64BitAtomics(@NotNull KonanTarget $this$supports64BitAtomics) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$supports64BitAtomics, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$supports64BitAtomics.getArchitecture().ordinal()]) {
            case 4: {
                bl = false;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl && !Intrinsics.areEqual((Object)$this$supports64BitAtomics, (Object)KonanTarget.WATCHOS_ARM64.INSTANCE);
    }

    public static final boolean supportsUnalignedAccess(@NotNull KonanTarget $this$supportsUnalignedAccess) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$supportsUnalignedAccess, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$supportsUnalignedAccess.getArchitecture().ordinal()]) {
            case 4: {
                bl = false;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl && !Intrinsics.areEqual((Object)$this$supportsUnalignedAccess, (Object)KonanTarget.WATCHOS_ARM64.INSTANCE);
    }

    public static final boolean needSmallBinary(@NotNull KonanTarget $this$needSmallBinary) {
        Intrinsics.checkNotNullParameter((Object)$this$needSmallBinary, (String)"<this>");
        return $this$needSmallBinary.getFamily() == Family.WATCHOS ? true : ($this$needSmallBinary.getFamily().isAppleFamily() ? $this$needSmallBinary.getArchitecture() == Architecture.ARM32 : false);
    }

    @NotNull
    public static final List<SanitizerKind> supportedSanitizers(@NotNull KonanTarget $this$supportedSanitizers) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$supportedSanitizers, (String)"<this>");
        KonanTarget konanTarget = $this$supportedSanitizers;
        if (konanTarget instanceof KonanTarget.LINUX_X64) {
            SanitizerKind[] sanitizerKindArray = new SanitizerKind[]{SanitizerKind.ADDRESS, SanitizerKind.THREAD};
            list = CollectionsKt.listOf((Object[])sanitizerKindArray);
        } else {
            list = konanTarget instanceof KonanTarget.MACOS_X64 ? CollectionsKt.listOf((Object)((Object)SanitizerKind.THREAD)) : (konanTarget instanceof KonanTarget.MACOS_ARM64 ? CollectionsKt.listOf((Object)((Object)SanitizerKind.THREAD)) : CollectionsKt.emptyList());
        }
        return list;
    }

    public static final boolean getSupportsGrandCentralDispatch(@NotNull KonanTarget $this$supportsGrandCentralDispatch) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsGrandCentralDispatch, (String)"<this>");
        return $this$supportsGrandCentralDispatch.getFamily().isAppleFamily();
    }

    public static final boolean getSupportsSignposts(@NotNull KonanTarget $this$supportsSignposts) {
        Intrinsics.checkNotNullParameter((Object)$this$supportsSignposts, (String)"<this>");
        return $this$supportsSignposts.getFamily().isAppleFamily();
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Family.values().length];
            try {
                nArray[Family.WATCHOS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.IOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.TVOS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.OSX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.ANDROID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.LINUX.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Family.MINGW.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Architecture.values().length];
            try {
                nArray[Architecture.X64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Architecture.X86.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Architecture.ARM64.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Architecture.ARM32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

