/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.NamedDomainObjectCollectionSchema;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.plugins.BindsSoftwareFeature;
import org.gradle.api.internal.plugins.BindsSoftwareType;
import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.HasBuildModel;
import org.gradle.api.internal.plugins.SoftwareFeatureBinding;
import org.gradle.api.internal.plugins.SoftwareFeatureBindingBuilder;
import org.gradle.api.internal.plugins.SoftwareFeatureBindingRegistration;
import org.gradle.api.internal.plugins.SoftwareFeatureTransform;
import org.gradle.api.internal.plugins.SoftwareTypeBindingBuilder;
import org.gradle.api.internal.plugins.SoftwareTypeBindingRegistration;
import org.gradle.api.internal.tasks.properties.InspectionScheme;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.Cast;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;
import org.gradle.plugin.software.internal.CompatibleSoftwareFeatureRegistry;
import org.gradle.plugin.software.internal.DefaultBoundSoftwareFeatureImplementation;
import org.gradle.plugin.software.internal.DefaultSoftwareFeatureBindingBuilder;
import org.gradle.plugin.software.internal.DefaultSoftwareTypeBindingBuilder;
import org.gradle.plugin.software.internal.LegacySoftwareTypeDiscovery;
import org.gradle.plugin.software.internal.SoftwareFeatureImplementation;
import org.jspecify.annotations.Nullable;

public class DefaultSoftwareFeatureRegistry
extends CompatibleSoftwareFeatureRegistry {
    private final Map<RegisteringPluginKey, Set<Class<? extends Plugin<Project>>>> pluginClasses = new LinkedHashMap<RegisteringPluginKey, Set<Class<? extends Plugin<Project>>>>();
    private final Map<String, Class<? extends Plugin<Project>>> registeredTypes = new HashMap<String, Class<? extends Plugin<Project>>>();
    private @Nullable Map<String, SoftwareFeatureImplementation<?, ?>> softwareFeatureImplementations;
    private final InspectionScheme inspectionScheme;
    private final Instantiator instantiator;
    private final LegacySoftwareTypeDiscovery legacySoftwareTypeDiscovery;

    public DefaultSoftwareFeatureRegistry(InspectionScheme inspectionScheme, Instantiator instantiator) {
        this.inspectionScheme = inspectionScheme;
        this.instantiator = instantiator;
        this.legacySoftwareTypeDiscovery = new LegacySoftwareTypeDiscovery(inspectionScheme);
    }

    public void register(@Nullable String pluginId, Class<? extends Plugin<Project>> pluginClass, Class<? extends Plugin<Settings>> registeringPluginClass) {
        if (this.softwareFeatureImplementations != null) {
            throw new IllegalStateException("Cannot register a plugin after software types have been discovered");
        }
        RegisteringPluginKey pluginKey = new RegisteringPluginKey(registeringPluginClass, pluginId);
        this.pluginClasses.computeIfAbsent(pluginKey, k -> new LinkedHashSet()).add(pluginClass);
    }

    private Map<String, SoftwareFeatureImplementation<?, ?>> discoverSoftwareFeatureImplementations() {
        ImmutableMap.Builder softwareFeatureImplementationsBuilder = ImmutableMap.builder();
        this.pluginClasses.forEach((registeringPluginClass, registeredPluginClasses) -> registeredPluginClasses.forEach(pluginClass -> {
            TypeMetadata pluginClassTypeMetadata = this.inspectionScheme.getMetadataStore().getTypeMetadata(pluginClass);
            TypeAnnotationMetadata pluginClassAnnotationMetadata = pluginClassTypeMetadata.getTypeAnnotationMetadata();
            this.registerSoftwareTypeIfPresent((RegisteringPluginKey)registeringPluginClass, (Class<? extends Plugin<Project>>)pluginClass, pluginClassAnnotationMetadata, (ImmutableMap.Builder<String, SoftwareFeatureImplementation<?, ?>>)softwareFeatureImplementationsBuilder);
            this.registerSoftwareFeatureIfPresent((RegisteringPluginKey)registeringPluginClass, (Class<? extends Plugin<Project>>)pluginClass, pluginClassAnnotationMetadata, (ImmutableMap.Builder<String, SoftwareFeatureImplementation<?, ?>>)softwareFeatureImplementationsBuilder);
        }));
        this.legacySoftwareTypeDiscovery.discoverSoftwareTypeImplementations(this.registeredTypes, this.pluginClasses).forEach(implementation -> softwareFeatureImplementationsBuilder.put((Object)implementation.getFeatureName(), implementation));
        return softwareFeatureImplementationsBuilder.build();
    }

    private <T extends HasBuildModel<V>, V extends BuildModel> void registerFeature(RegisteringPluginKey registeringPlugin, Class<? extends Plugin<Project>> pluginClass, SoftwareFeatureBinding<T, V> binding, ImmutableMap.Builder<String, SoftwareFeatureImplementation<?, ?>> softwareFeatureImplementationsBuilder) {
        String softwareFeatureName = binding.getName();
        Class<? extends Plugin<Project>> existingPluginClass = this.registeredTypes.put(softwareFeatureName, pluginClass);
        if (existingPluginClass != null && existingPluginClass != pluginClass) {
            throw new IllegalArgumentException("Software type '" + softwareFeatureName + "' is registered by both '" + pluginClass.getName() + "' and '" + existingPluginClass.getName() + "'");
        }
        softwareFeatureImplementationsBuilder.put((Object)softwareFeatureName, new DefaultBoundSoftwareFeatureImplementation(softwareFeatureName, binding.getDslType(), binding.getDslImplementationType().orElse(binding.getDslType()), binding.targetDefinitionType(), binding.getBuildModelType(), binding.getBuildModelImplementationType().orElse(binding.getBuildModelType()), pluginClass, registeringPlugin.pluginClass, registeringPlugin.pluginId, (SoftwareFeatureTransform)Cast.uncheckedCast((Object)binding.getTransform())));
    }

    private void registerSoftwareFeatureIfPresent(RegisteringPluginKey registeringPluginClass, Class<? extends Plugin<Project>> pluginClass, TypeAnnotationMetadata pluginClassAnnotationMetadata, ImmutableMap.Builder<String, SoftwareFeatureImplementation<?, ?>> softwareFeatureImplementationsBuilder) {
        Optional bindsSoftwareTypeAnnotation = pluginClassAnnotationMetadata.getAnnotation(BindsSoftwareFeature.class);
        if (bindsSoftwareTypeAnnotation.isPresent()) {
            BindsSoftwareFeature bindsSoftwareType = (BindsSoftwareFeature)bindsSoftwareTypeAnnotation.get();
            Class bindingRegistrationClass = bindsSoftwareType.value();
            SoftwareFeatureBindingRegistration bindingRegistration = (SoftwareFeatureBindingRegistration)this.instantiator.newInstance(bindingRegistrationClass, new Object[0]);
            DefaultSoftwareFeatureBindingBuilder builder = new DefaultSoftwareFeatureBindingBuilder();
            bindingRegistration.register((SoftwareFeatureBindingBuilder)builder);
            builder.build().forEach(binding -> this.registerFeature(registeringPluginClass, pluginClass, (SoftwareFeatureBinding)binding, softwareFeatureImplementationsBuilder));
        }
    }

    private void registerSoftwareTypeIfPresent(RegisteringPluginKey registeringPluginKey, Class<? extends Plugin<Project>> pluginClass, TypeAnnotationMetadata pluginClassAnnotationMetadata, ImmutableMap.Builder<String, SoftwareFeatureImplementation<?, ?>> softwareFeatureImplementationsBuilder) {
        Optional bindsSoftwareTypeAnnotation = pluginClassAnnotationMetadata.getAnnotation(BindsSoftwareType.class);
        if (bindsSoftwareTypeAnnotation.isPresent()) {
            BindsSoftwareType bindsSoftwareType = (BindsSoftwareType)bindsSoftwareTypeAnnotation.get();
            Class bindingRegistrationClass = bindsSoftwareType.value();
            SoftwareTypeBindingRegistration bindingRegistration = (SoftwareTypeBindingRegistration)this.instantiator.newInstance(bindingRegistrationClass, new Object[0]);
            DefaultSoftwareTypeBindingBuilder builder = new DefaultSoftwareTypeBindingBuilder();
            bindingRegistration.register((SoftwareTypeBindingBuilder)builder);
            builder.build().forEach(binding -> this.registerFeature(registeringPluginKey, pluginClass, (SoftwareFeatureBinding)binding, softwareFeatureImplementationsBuilder));
        }
    }

    public Map<String, SoftwareFeatureImplementation<?, ?>> getSoftwareFeatureImplementations() {
        if (this.softwareFeatureImplementations == null) {
            this.softwareFeatureImplementations = this.discoverSoftwareFeatureImplementations();
        }
        return this.softwareFeatureImplementations;
    }

    public NamedDomainObjectCollectionSchema getSchema() {
        return () -> Iterables.transform(() -> this.getSoftwareFeatureImplementations().entrySet().iterator(), entry -> new SoftwareFeatureSchema((String)entry.getKey(), ((SoftwareFeatureImplementation)entry.getValue()).getDefinitionPublicType()));
    }

    public static class RegisteringPluginKey {
        public final Class<? extends Plugin<Settings>> pluginClass;
        public final @Nullable String pluginId;

        public RegisteringPluginKey(Class<? extends Plugin<Settings>> pluginClass, @Nullable String pluginId) {
            this.pluginClass = pluginClass;
            this.pluginId = pluginId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RegisteringPluginKey)) {
                return false;
            }
            RegisteringPluginKey pluginKey = (RegisteringPluginKey)o;
            return Objects.equals(this.pluginClass, pluginKey.pluginClass) && Objects.equals(this.pluginId, pluginKey.pluginId);
        }

        public int hashCode() {
            return Objects.hash(this.pluginClass, this.pluginId);
        }
    }

    private static class SoftwareFeatureSchema
    implements NamedDomainObjectCollectionSchema.NamedDomainObjectSchema {
        private final String name;
        private final Class<?> modelPublicType;

        public SoftwareFeatureSchema(String name, Class<?> modelPublicType) {
            this.name = name;
            this.modelPublicType = modelPublicType;
        }

        public String getName() {
            return this.name;
        }

        public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(this.modelPublicType);
        }
    }
}

