/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gradle.initialization.ProjectDescriptorInternal;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Settings.class})
public class DefaultProjectDescriptorRegistry
implements ProjectDescriptorRegistry {
    private final Map<String, ProjectDescriptorInternal> projects = new HashMap<String, ProjectDescriptorInternal>();

    @Override
    public void addProject(ProjectDescriptorInternal project) {
        ProjectDescriptorInternal previous = this.projects.put(project.getPath(), project);
        if (previous != null) {
            throw new IllegalArgumentException(String.format("Multiple projects registered for path '%s'.", project.getPath()));
        }
    }

    public ProjectDescriptorInternal removeProject(String path) {
        ProjectDescriptorInternal project = this.projects.remove(path);
        assert (project != null);
        return project;
    }

    @Override
    public int size() {
        return this.projects.size();
    }

    @Override
    public Set<ProjectDescriptorInternal> getAllProjects() {
        return ImmutableSet.copyOf(this.projects.values());
    }

    @Override
    public @Nullable ProjectDescriptorInternal getRootProject() {
        return this.getProject(Path.ROOT.getPath());
    }

    @Override
    public @Nullable ProjectDescriptorInternal getProject(String path) {
        return this.projects.get(path);
    }

    @Override
    public void changeDescriptorPath(Path oldPath, Path newPath) {
        ProjectDescriptorInternal projectDescriptor = this.removeProject(oldPath.toString());
        projectDescriptor.setPath(newPath);
        this.addProject(projectDescriptor);
    }
}

