/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.initialization;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Task;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.internal.cc.impl.DeprecatedFeaturesListenerKt;
import org.gradle.internal.cc.impl.InputTrackingState;
import org.gradle.internal.cc.impl.Workarounds;
import org.gradle.internal.cc.impl.initialization.ConfigurationCacheProblemsListener;
import org.gradle.internal.configuration.problems.DocumentationSection;
import org.gradle.internal.configuration.problems.ProblemFactory;
import org.gradle.internal.configuration.problems.ProblemsListener;
import org.gradle.internal.configuration.problems.PropertyProblem;
import org.gradle.internal.configuration.problems.PropertyTrace;
import org.gradle.internal.configuration.problems.StructuredMessage;
import org.gradle.internal.execution.WorkExecutionTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B1\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ$\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\"\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\"\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\"\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\u001a\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0016J\"\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010$\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010'\u001a\u00020&H\u0016J\u0018\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020&H\u0002J\b\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020-H\u0002J\b\u00100\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/gradle/internal/cc/impl/initialization/DefaultConfigurationCacheProblemsListener;", "Lorg/gradle/internal/cc/impl/initialization/ConfigurationCacheProblemsListener;", "problems", "Lorg/gradle/internal/configuration/problems/ProblemsListener;", "problemFactory", "Lorg/gradle/internal/configuration/problems/ProblemFactory;", "configurationTimeBarrier", "Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;", "workExecutionTracker", "Lorg/gradle/internal/execution/WorkExecutionTracker;", "inputTrackingState", "Lorg/gradle/internal/cc/impl/InputTrackingState;", "<init>", "(Lorg/gradle/internal/configuration/problems/ProblemsListener;Lorg/gradle/internal/configuration/problems/ProblemFactory;Lorg/gradle/api/internal/provider/ConfigurationTimeBarrier;Lorg/gradle/internal/execution/WorkExecutionTracker;Lorg/gradle/internal/cc/impl/InputTrackingState;)V", "disallowedAtExecutionInjectedServiceAccessed", "", "injectedServiceType", "Ljava/lang/Class;", "getterName", "", "consumer", "onProjectAccess", "invocationDescription", "task", "Lorg/gradle/api/internal/TaskInternal;", "runningTask", "onConventionAccess", "onTaskDependenciesAccess", "onExternalProcessStarted", "command", "onTaskExecutionAccessProblem", "locationForTask", "Lorg/gradle/internal/configuration/problems/PropertyTrace;", "location", "Lorg/gradle/internal/configuration/problems/PropertyTrace$Task;", "problemsListenerFor", "onBuildScopeListenerRegistration", "listener", "", "invocationSource", "listenerRegistrationProblem", "Lorg/gradle/internal/configuration/problems/PropertyProblem;", "exception", "Lorg/gradle/api/InvalidUserCodeException;", "isBuildSrcBuild", "", "atConfigurationTime", "isInputTrackingDisabled", "isExecutingWork", "configuration-cache"})
public final class DefaultConfigurationCacheProblemsListener
implements ConfigurationCacheProblemsListener {
    @NotNull
    private final ProblemsListener problems;
    @NotNull
    private final ProblemFactory problemFactory;
    @NotNull
    private final ConfigurationTimeBarrier configurationTimeBarrier;
    @NotNull
    private final WorkExecutionTracker workExecutionTracker;
    @NotNull
    private final InputTrackingState inputTrackingState;

    public DefaultConfigurationCacheProblemsListener(@NotNull ProblemsListener problems2, @NotNull ProblemFactory problemFactory, @NotNull ConfigurationTimeBarrier configurationTimeBarrier, @NotNull WorkExecutionTracker workExecutionTracker, @NotNull InputTrackingState inputTrackingState) {
        Intrinsics.checkNotNullParameter((Object)problems2, (String)"problems");
        Intrinsics.checkNotNullParameter((Object)problemFactory, (String)"problemFactory");
        Intrinsics.checkNotNullParameter((Object)configurationTimeBarrier, (String)"configurationTimeBarrier");
        Intrinsics.checkNotNullParameter((Object)workExecutionTracker, (String)"workExecutionTracker");
        Intrinsics.checkNotNullParameter((Object)inputTrackingState, (String)"inputTrackingState");
        this.problems = problems2;
        this.problemFactory = problemFactory;
        this.configurationTimeBarrier = configurationTimeBarrier;
        this.workExecutionTracker = workExecutionTracker;
        this.inputTrackingState = inputTrackingState;
    }

    public void disallowedAtExecutionInjectedServiceAccessed(@NotNull Class<?> injectedServiceType, @NotNull String getterName, @NotNull String consumer) {
        Intrinsics.checkNotNullParameter(injectedServiceType, (String)"injectedServiceType");
        Intrinsics.checkNotNullParameter((Object)getterName, (String)"getterName");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        PropertyProblem problem = this.problemFactory.problem(consumer, arg_0 -> DefaultConfigurationCacheProblemsListener.disallowedAtExecutionInjectedServiceAccessed$lambda$0(injectedServiceType, getterName, arg_0)).exception("Accessing non-serializable type '" + injectedServiceType + "' during execution time is unsupported.").documentationSection(DocumentationSection.RequirementsDisallowedTypes).build();
        this.problems.onExecutionTimeProblem(problem);
    }

    public void onProjectAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    public void onConventionAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String string = task.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (Workarounds.INSTANCE.canAccessConventions(string, invocationDescription)) {
            return;
        }
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    public void onTaskDependenciesAccess(@NotNull String invocationDescription, @NotNull TaskInternal task, @Nullable TaskInternal runningTask) {
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.onTaskExecutionAccessProblem(invocationDescription, task, runningTask);
    }

    public void onExternalProcessStarted(@NotNull String command, @Nullable String consumer) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (!this.atConfigurationTime() || this.isExecutingWork() || this.isInputTrackingDisabled()) {
            return;
        }
        PropertyProblem problem = this.problemFactory.problem(consumer, arg_0 -> DefaultConfigurationCacheProblemsListener.onExternalProcessStarted$lambda$1(command, arg_0)).exception("Starting an external process '" + command + "' during configuration time is unsupported.").documentationSection(DocumentationSection.RequirementsExternalProcess).build();
        this.problems.onProblem(problem);
    }

    private final void onTaskExecutionAccessProblem(String invocationDescription, TaskInternal task, TaskInternal runningTask) {
        TaskInternal contextTask;
        TaskInternal taskInternal = runningTask;
        if (taskInternal == null) {
            taskInternal = task;
        }
        boolean isExecutingOtherTask = !Intrinsics.areEqual((Object)(contextTask = taskInternal), (Object)task);
        this.problemsListenerFor(contextTask).onExecutionTimeProblem(ProblemFactory.problem$default((ProblemFactory)this.problemFactory, null, arg_0 -> DefaultConfigurationCacheProblemsListener.onTaskExecutionAccessProblem$lambda$2(isExecutingOtherTask, contextTask, invocationDescription, arg_0), (int)1, null).exception(isExecutingOtherTask ? "Execution of " + runningTask + " caused invocation of '" + invocationDescription + "' by " + task + " at execution time which is unsupported with the configuration cache." : "Invocation of '" + invocationDescription + "' by " + task + " at execution time is unsupported with the configuration cache.").documentationSection(DocumentationSection.RequirementsUseProjectDuringExecution).mapLocation(arg_0 -> DefaultConfigurationCacheProblemsListener.onTaskExecutionAccessProblem$lambda$3(this, contextTask, arg_0)).build());
    }

    private final PropertyTrace locationForTask(PropertyTrace location, TaskInternal task) {
        PropertyTrace propertyTrace = location;
        return propertyTrace instanceof PropertyTrace.BuildLogic ? location : (propertyTrace instanceof PropertyTrace.Task ? location : (PropertyTrace)this.locationForTask(task));
    }

    private final PropertyTrace.Task locationForTask(TaskInternal task) {
        Class clazz = GeneratedSubclasses.unpackType((Object)task);
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"unpackType(...)");
        String string = task.getIdentityPath().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return new PropertyTrace.Task(clazz, string);
    }

    private final ProblemsListener problemsListenerFor(TaskInternal task) {
        ProblemsListener problemsListener;
        PropertyTrace.Task trace = this.locationForTask(task);
        if (!task.isCompatibleWithConfigurationCache()) {
            PropertyTrace propertyTrace = (PropertyTrace)trace;
            Object t = task.getReasonTaskIsIncompatibleWithConfigurationCache().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            problemsListener = this.problems.forIncompatibleTask(propertyTrace, (String)t);
        } else {
            problemsListener = this.problems.forTask((Task)task);
        }
        return problemsListener;
    }

    public void onBuildScopeListenerRegistration(@NotNull Object listener2, @NotNull String invocationDescription, @NotNull Object invocationSource) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)invocationDescription, (String)"invocationDescription");
        Intrinsics.checkNotNullParameter((Object)invocationSource, (String)"invocationSource");
        if (this.isBuildSrcBuild(invocationSource) || DeprecatedFeaturesListenerKt.isSupportedListener(listener2)) {
            return;
        }
        this.problems.onProblem(this.listenerRegistrationProblem(invocationDescription, new InvalidUserCodeException("Listener registration '" + invocationDescription + "' by " + invocationSource + " is unsupported.")));
    }

    private final PropertyProblem listenerRegistrationProblem(String invocationDescription, InvalidUserCodeException exception) {
        return ProblemFactory.problem$default((ProblemFactory)this.problemFactory, (StructuredMessage)StructuredMessage.Companion.build(arg_0 -> DefaultConfigurationCacheProblemsListener.listenerRegistrationProblem$lambda$4(invocationDescription, arg_0)), (Throwable)((Throwable)exception), (DocumentationSection)DocumentationSection.RequirementsBuildListeners, (boolean)false, (int)8, null);
    }

    private final boolean isBuildSrcBuild(Object invocationSource) {
        boolean bl;
        GradleInternal gradleInternal = invocationSource instanceof GradleInternal ? (GradleInternal)invocationSource : null;
        if (gradleInternal != null) {
            GradleInternal $this$isBuildSrcBuild_u24lambda_u245 = gradleInternal;
            boolean bl2 = false;
            bl = !$this$isBuildSrcBuild_u24lambda_u245.isRootBuild() && Intrinsics.areEqual((Object)$this$isBuildSrcBuild_u24lambda_u245.getIdentityPath().getName(), (Object)"buildSrc");
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean atConfigurationTime() {
        return this.configurationTimeBarrier.isAtConfigurationTime();
    }

    private final boolean isInputTrackingDisabled() {
        return !this.inputTrackingState.isEnabledForCurrentThread();
    }

    private final boolean isExecutingWork() {
        return this.workExecutionTracker.isExecutingTaskOrTransformAction();
    }

    private static final Unit disallowedAtExecutionInjectedServiceAccessed$lambda$0(Class $injectedServiceType, String $getterName, StructuredMessage.Builder $this$problem) {
        Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
        $this$problem.text("accessing non-serializable type ");
        $this$problem.reference($injectedServiceType);
        $this$problem.text(" caused by invocation ");
        $this$problem.reference($getterName);
        return Unit.INSTANCE;
    }

    private static final Unit onExternalProcessStarted$lambda$1(String $command, StructuredMessage.Builder $this$problem) {
        Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
        $this$problem.text("external process started ");
        $this$problem.reference($command);
        return Unit.INSTANCE;
    }

    private static final Unit onTaskExecutionAccessProblem$lambda$2(boolean $isExecutingOtherTask, TaskInternal $contextTask, String $invocationDescription, StructuredMessage.Builder $this$problem) {
        Intrinsics.checkNotNullParameter((Object)$this$problem, (String)"$this$problem");
        if ($isExecutingOtherTask) {
            $this$problem.text("execution of task ");
            String string = $contextTask.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            $this$problem.reference(string);
            $this$problem.text(" caused invocation of ");
            $this$problem.reference($invocationDescription);
            v1 = $this$problem.text(" in other task at execution time which is unsupported with the configuration cache.");
        } else {
            $this$problem.text("invocation of ");
            $this$problem.reference($invocationDescription);
            v1 = $this$problem.text(" at execution time is unsupported with the configuration cache.");
        }
        return Unit.INSTANCE;
    }

    private static final PropertyTrace onTaskExecutionAccessProblem$lambda$3(DefaultConfigurationCacheProblemsListener this$0, TaskInternal $contextTask, PropertyTrace it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.locationForTask(it, $contextTask);
    }

    private static final Unit listenerRegistrationProblem$lambda$4(String $invocationDescription, StructuredMessage.Builder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        $this$build.text("registration of listener on ");
        $this$build.reference($invocationDescription);
        $this$build.text(" is unsupported");
        return Unit.INSTANCE;
    }
}

