/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectLifecycleController;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.initialization.ProjectDescriptorInternal;
import org.gradle.initialization.ProjectDescriptorRegistry;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.build.BuildProjectRegistry;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.model.StateTransitionControllerFactory;
import org.gradle.internal.resources.ProjectLeaseRegistry;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public class DefaultProjectStateRegistry
implements ProjectStateRegistry,
Closeable {
    private final WorkerLeaseService workerLeaseService;
    private final Object lock = new Object();
    private final Map<Path, ProjectStateImpl> projectsByPath = new LinkedHashMap<Path, ProjectStateImpl>();
    private final Map<ProjectComponentIdentifier, ProjectStateImpl> projectsById = new HashMap<ProjectComponentIdentifier, ProjectStateImpl>();
    private final Map<BuildIdentifier, DefaultBuildProjectRegistry> projectsByBuild = new HashMap<BuildIdentifier, DefaultBuildProjectRegistry>();

    public DefaultProjectStateRegistry(WorkerLeaseService workerLeaseService) {
        this.workerLeaseService = workerLeaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProjects(BuildState owner, ProjectDescriptorRegistry projectRegistry) {
        Set<ProjectDescriptorInternal> allProjects = projectRegistry.getAllProjects();
        Object object = this.lock;
        synchronized (object) {
            DefaultBuildProjectRegistry buildProjectRegistry = this.getBuildProjectRegistry(owner);
            if (!buildProjectRegistry.projectsByPath.isEmpty()) {
                throw new IllegalStateException("Projects for " + owner.getDisplayName() + " have already been registered.");
            }
            for (ProjectDescriptorInternal descriptor : allProjects) {
                this.addProject(owner, buildProjectRegistry, descriptor);
            }
        }
    }

    private DefaultBuildProjectRegistry getBuildProjectRegistry(BuildState owner) {
        DefaultBuildProjectRegistry buildProjectRegistry = this.projectsByBuild.get(owner.getBuildIdentifier());
        if (buildProjectRegistry == null) {
            buildProjectRegistry = new DefaultBuildProjectRegistry(owner, this.workerLeaseService);
            this.projectsByBuild.put(owner.getBuildIdentifier(), buildProjectRegistry);
        }
        return buildProjectRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState registerProject(BuildState owner, ProjectDescriptorInternal projectDescriptor) {
        Object object = this.lock;
        synchronized (object) {
            DefaultBuildProjectRegistry buildProjectRegistry = this.getBuildProjectRegistry(owner);
            return this.addProject(owner, buildProjectRegistry, projectDescriptor);
        }
    }

    @Override
    public void discardProjectsFor(BuildState build) {
        DefaultBuildProjectRegistry registry = this.projectsByBuild.get(build.getBuildIdentifier());
        if (registry != null) {
            for (ProjectStateImpl project : registry.projectsByPath.values()) {
                this.projectsById.remove(project.getComponentIdentifier());
                this.projectsByPath.remove(project.getIdentityPath());
            }
            CompositeStoppable.stoppable(registry.projectsByPath.values()).stop();
            registry.projectsByPath.clear();
        }
    }

    private ProjectState addProject(BuildState owner, DefaultBuildProjectRegistry projectRegistry, ProjectDescriptorInternal descriptor) {
        Path projectPath = descriptor.path();
        ProjectIdentity identity = projectPath.equals((Object)Path.ROOT) ? ProjectIdentity.forRootProject((Path)owner.getIdentityPath(), (String)descriptor.getName()) : ProjectIdentity.forSubproject((Path)owner.getIdentityPath(), (Path)projectPath);
        ServiceRegistry buildServices = owner.getMutableModel().getServices();
        IProjectFactory projectFactory = (IProjectFactory)buildServices.get(IProjectFactory.class);
        StateTransitionControllerFactory stateTransitionControllerFactory = (StateTransitionControllerFactory)buildServices.get(StateTransitionControllerFactory.class);
        ProjectStateImpl projectState = new ProjectStateImpl(owner, identity, descriptor, projectFactory, stateTransitionControllerFactory, buildServices);
        this.projectsByPath.put(identity.getBuildTreePath(), projectState);
        this.projectsById.put(projectState.getComponentIdentifier(), projectState);
        projectRegistry.add(projectPath, projectState);
        return projectState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ProjectStateImpl> getAllProjects() {
        Object object = this.lock;
        synchronized (object) {
            return this.projectsByPath.values();
        }
    }

    @Override
    public ProjectState stateFor(Project project) {
        return ((ProjectInternal)project).getOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(ProjectComponentIdentifier identifier) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsById.get(identifier);
            if (projectState == null) {
                throw new IllegalArgumentException(identifier.getDisplayName() + " not found.");
            }
            return projectState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectState stateFor(Path identityPath) {
        Object object = this.lock;
        synchronized (object) {
            ProjectStateImpl projectState = this.projectsByPath.get(identityPath);
            if (projectState == null) {
                throw new IllegalArgumentException(identityPath.getPath() + " not found.");
            }
            return projectState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable ProjectState findProjectState(Path identityPath) {
        Object object = this.lock;
        synchronized (object) {
            return this.projectsByPath.get(identityPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildProjectRegistry projectsFor(BuildIdentifier buildIdentifier) throws IllegalArgumentException {
        Object object = this.lock;
        synchronized (object) {
            BuildProjectRegistry registry = this.projectsByBuild.get(buildIdentifier);
            if (registry == null) {
                throw new IllegalArgumentException("Projects for " + buildIdentifier + " have not been registered yet.");
            }
            return registry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable BuildProjectRegistry findProjectsFor(BuildIdentifier buildIdentifier) {
        Object object = this.lock;
        synchronized (object) {
            return this.projectsByBuild.get(buildIdentifier);
        }
    }

    @Override
    public <T> T allowUncontrolledAccessToAnyProject(Factory<T> factory) {
        return (T)this.workerLeaseService.allowUncontrolledAccessToAnyProject(factory);
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.projectsByPath.values()).stop();
    }

    private static class DefaultBuildProjectRegistry
    implements BuildProjectRegistry {
        private final BuildState owner;
        private final WorkerLeaseService workerLeaseService;
        private final Map<Path, ProjectStateImpl> projectsByPath = new LinkedHashMap<Path, ProjectStateImpl>();

        public DefaultBuildProjectRegistry(BuildState owner, WorkerLeaseService workerLeaseService) {
            this.owner = owner;
            this.workerLeaseService = workerLeaseService;
        }

        public void add(Path projectPath, ProjectStateImpl projectState) {
            this.projectsByPath.put(projectPath, projectState);
        }

        @Override
        public ProjectState getRootProject() {
            return this.getProject(Path.ROOT);
        }

        @Override
        public ProjectState getProject(Path projectPath) {
            ProjectStateImpl projectState = this.projectsByPath.get(projectPath);
            if (projectState == null) {
                throw new IllegalArgumentException("Project with path '" + projectPath + "' not found in " + this.owner.getDisplayName() + ".");
            }
            return projectState;
        }

        @Override
        public @Nullable ProjectState findProject(Path projectPath) {
            return this.projectsByPath.get(projectPath);
        }

        @Override
        public Set<? extends ProjectState> getAllProjects() {
            TreeSet<ProjectState> projects = new TreeSet<ProjectState>(Comparator.comparing(ProjectState::getIdentityPath));
            projects.addAll(this.projectsByPath.values());
            return projects;
        }

        @Override
        public void withMutableStateOfAllProjects(Runnable runnable) {
            this.withMutableStateOfAllProjects(Factories.toFactory((Runnable)runnable));
        }

        @Override
        public <T> T withMutableStateOfAllProjects(Factory<T> factory) {
            ResourceLock allProjectsLock = this.workerLeaseService.getAllProjectsLock(this.owner.getIdentityPath());
            Collection locks = this.workerLeaseService.getCurrentProjectLocks();
            return (T)this.workerLeaseService.withReplacedLocks(locks, allProjectsLock, factory);
        }
    }

    private class ProjectStateImpl
    implements ProjectState,
    Closeable {
        private final ProjectDescriptorInternal descriptor;
        private final IProjectFactory projectFactory;
        private final BuildState owner;
        private final ProjectIdentity identity;
        private final ResourceLock allProjectsLock;
        private final ResourceLock projectLock;
        private final ResourceLock taskLock;
        private final Set<Thread> canDoAnythingToThisProject = new CopyOnWriteArraySet<Thread>();
        private final ProjectLifecycleController controller;
        private final Lazy<Integer> depth = Lazy.unsafe().of(() -> this.getParent() != null ? this.getParent().getDepth() + 1 : 0);

        ProjectStateImpl(BuildState owner, ProjectIdentity identity, ProjectDescriptorInternal descriptor, IProjectFactory projectFactory, StateTransitionControllerFactory stateTransitionControllerFactory, ServiceRegistry buildServices) {
            this.owner = owner;
            this.descriptor = descriptor;
            this.projectFactory = projectFactory;
            this.identity = identity;
            this.allProjectsLock = DefaultProjectStateRegistry.this.workerLeaseService.getAllProjectsLock(owner.getIdentityPath());
            this.projectLock = DefaultProjectStateRegistry.this.workerLeaseService.getProjectLock(owner.getIdentityPath(), identity.getBuildTreePath());
            this.taskLock = DefaultProjectStateRegistry.this.workerLeaseService.getTaskExecutionLock(owner.getIdentityPath(), identity.getBuildTreePath());
            this.controller = new ProjectLifecycleController(this.getDisplayName(), stateTransitionControllerFactory, buildServices);
        }

        @Override
        public DisplayName getDisplayName() {
            Path identityPath = this.identity.getBuildTreePath();
            if (identityPath.equals((Object)Path.ROOT)) {
                return Describables.withTypeAndName((Object)"root project", (String)this.identity.getProjectName());
            }
            return Describables.withTypeAndName((Object)"project", (String)identityPath.getPath());
        }

        public String toString() {
            return this.getDisplayName().getDisplayName();
        }

        @Override
        public BuildState getOwner() {
            return this.owner;
        }

        @Override
        public @Nullable ProjectState getParent() {
            Path identityPath = this.identity.getBuildTreePath();
            return identityPath.getParent() == null ? null : (ProjectState)DefaultProjectStateRegistry.this.projectsByPath.get(identityPath.getParent());
        }

        @Override
        public @Nullable ProjectState getBuildParent() {
            if (this.descriptor.getParent() != null) {
                Path parentProjectPath = this.descriptor.getParent().path();
                Path parentIdentityPath = ProjectIdentity.computeProjectIdentityPath((Path)this.owner.getIdentityPath(), (Path)parentProjectPath);
                ProjectStateImpl parentState = (ProjectStateImpl)DefaultProjectStateRegistry.this.projectsByPath.get(parentIdentityPath);
                if (parentState == null) {
                    throw new IllegalStateException("Parent project " + parentIdentityPath + " is not registered for " + this.identity);
                }
                return parentState;
            }
            return null;
        }

        @Override
        public Set<ProjectState> getChildProjects() {
            TreeSet<ProjectState> children = new TreeSet<ProjectState>(Comparator.comparing(ProjectState::getIdentityPath));
            for (ProjectDescriptorInternal child : this.descriptor.children()) {
                children.add(this.getStateForChild(child));
            }
            return children;
        }

        @Override
        public Iterable<ProjectState> getUnorderedChildProjects() {
            return Iterables.transform(this.descriptor.children(), this::getStateForChild);
        }

        @Override
        public boolean hasChildren() {
            return !this.descriptor.children().isEmpty();
        }

        private ProjectStateImpl getStateForChild(ProjectDescriptorInternal child) {
            Path childProjectPath = child.path();
            Path childIdentityPath = ProjectIdentity.computeProjectIdentityPath((Path)this.owner.getIdentityPath(), (Path)childProjectPath);
            return (ProjectStateImpl)DefaultProjectStateRegistry.this.projectsByPath.get(childIdentityPath);
        }

        @Override
        public String getName() {
            return this.identity.getProjectName();
        }

        @Override
        public Path getIdentityPath() {
            return this.identity.getBuildTreePath();
        }

        @Override
        public ProjectIdentity getIdentity() {
            return this.identity;
        }

        @Override
        public Path getProjectPath() {
            return this.identity.getProjectPath();
        }

        @Override
        public File getProjectDir() {
            return this.descriptor.getProjectDir();
        }

        @Override
        public int getDepth() {
            return (Integer)this.depth.get();
        }

        @Override
        public boolean isCreated() {
            return this.controller.isCreated();
        }

        @Override
        public void createMutableModel(ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope) {
            this.controller.createMutableModel(this.descriptor, this.owner, this, selfClassLoaderScope, baseClassLoaderScope, this.projectFactory);
        }

        @Override
        public ProjectInternal getMutableModel() {
            return this.controller.getMutableModel();
        }

        @Override
        public void ensureConfigured() {
            ProjectState parent = this.getBuildParent();
            if (parent != null) {
                parent.ensureConfigured();
            }
            this.controller.ensureSelfConfigured();
        }

        @Override
        public void ensureSelfConfigured() {
            ProjectState parent = this.getBuildParent();
            if (parent != null) {
                ((ProjectStateImpl)parent).controller.assertConfigured();
            }
            this.controller.ensureSelfConfigured();
        }

        @Override
        public void ensureTasksDiscovered() {
            this.controller.ensureTasksDiscovered();
        }

        @Override
        public ProjectComponentIdentifier getComponentIdentifier() {
            return new DefaultProjectComponentIdentifier(this.identity);
        }

        @Override
        public ResourceLock getAccessLock() {
            return this.projectLock;
        }

        @Override
        public ResourceLock getTaskExecutionLock() {
            return this.taskLock;
        }

        public void applyToMutableState(Consumer<? super ProjectInternal> action) {
            this.fromMutableState(p -> {
                action.accept((ProjectInternal)p);
                return null;
            });
        }

        public <S> S fromMutableState(Function<? super ProjectInternal, ? extends S> function) {
            Thread currentThread = Thread.currentThread();
            if (DefaultProjectStateRegistry.this.workerLeaseService.isAllowedUncontrolledAccessToAnyProject() || this.canDoAnythingToThisProject.contains(currentThread)) {
                return function.apply(this.getMutableModel());
            }
            Collection currentLocks = DefaultProjectStateRegistry.this.workerLeaseService.getCurrentProjectLocks();
            if (currentLocks.contains(this.projectLock) || currentLocks.contains(this.allProjectsLock)) {
                if (currentLocks.size() == 1) {
                    return function.apply(this.getMutableModel());
                }
                throw new IllegalStateException("Current thread holds more than one project lock. It should hold only one project lock at any given time.");
            }
            return (S)DefaultProjectStateRegistry.this.workerLeaseService.withReplacedLocks(currentLocks, this.projectLock, () -> function.apply(this.getMutableModel()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <S> S forceAccessToMutableState(Function<? super ProjectInternal, ? extends S> factory) {
            Thread currentThread = Thread.currentThread();
            boolean added = this.canDoAnythingToThisProject.add(currentThread);
            try {
                S s = factory.apply(this.getMutableModel());
                return s;
            }
            finally {
                if (added) {
                    this.canDoAnythingToThisProject.remove(currentThread);
                }
            }
        }

        public boolean hasMutableState() {
            Thread currentThread = Thread.currentThread();
            if (this.canDoAnythingToThisProject.contains(currentThread) || DefaultProjectStateRegistry.this.workerLeaseService.isAllowedUncontrolledAccessToAnyProject()) {
                return true;
            }
            Collection locks = DefaultProjectStateRegistry.this.workerLeaseService.getCurrentProjectLocks();
            return locks.contains(this.projectLock) || locks.contains(this.allProjectsLock);
        }

        public <T> CalculatedModelValue<T> newCalculatedValue(@Nullable T initialValue) {
            return new CalculatedModelValueImpl<T>(this, DefaultProjectStateRegistry.this.workerLeaseService, initialValue);
        }

        @Override
        public void close() {
            this.controller.close();
        }
    }

    private static class CalculatedModelValueImpl<T>
    implements CalculatedModelValue<T> {
        private final ProjectLeaseRegistry projectLeaseRegistry;
        private final ModelContainer<?> owner;
        private final ReentrantLock lock = new ReentrantLock();
        private volatile T value;

        public CalculatedModelValueImpl(ProjectStateImpl owner, WorkerLeaseService projectLeaseRegistry, @Nullable T initialValue) {
            this.projectLeaseRegistry = projectLeaseRegistry;
            this.value = initialValue;
            this.owner = owner;
        }

        public T get() throws IllegalStateException {
            T currentValue = this.getOrNull();
            if (currentValue == null) {
                throw new IllegalStateException("No calculated value is available for " + this.owner);
            }
            return currentValue;
        }

        public T getOrNull() {
            return this.value;
        }

        public void set(T newValue) {
            this.assertCanMutate();
            this.value = newValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T update(Function<T, T> updateFunction) {
            this.acquireUpdateLock();
            try {
                T newValue = updateFunction.apply(this.value);
                this.value = newValue;
                T t = newValue;
                return t;
            }
            finally {
                this.releaseUpdateLock();
            }
        }

        private void acquireUpdateLock() {
            this.assertCanMutate();
            if (this.lock.tryLock()) {
                return;
            }
            this.projectLeaseRegistry.blocking(this.lock::lock);
        }

        private void assertCanMutate() {
            if (!this.owner.hasMutableState()) {
                throw new IllegalStateException("Current thread does not hold the state lock for " + this.owner);
            }
        }

        private void releaseUpdateLock() {
            this.lock.unlock();
        }
    }
}

