/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.GradleException;
import org.gradle.api.NonExtensible;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ValueSourceProviderFactory;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.api.provider.ValueSourceSpec;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Try;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.isolated.IsolationScheme;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueFactory;
import org.gradle.internal.service.CloseableServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.process.ExecOperations;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DefaultValueSourceProviderFactory
implements ValueSourceProviderFactory {
    private final InstantiatorFactory instantiatorFactory;
    private final IsolatableFactory isolatableFactory;
    private final GradleProperties gradleProperties;
    private final CalculatedValueFactory calculatedValueFactory;
    private final ExecOperations execOperations;
    private final AnonymousListenerBroadcast<ValueSourceProviderFactory.ValueListener> valueBroadcaster;
    private final AnonymousListenerBroadcast<ValueSourceProviderFactory.ComputationListener> computationBroadcaster;
    private final IsolationScheme<ValueSource, ValueSourceParameters> isolationScheme = new IsolationScheme<ValueSource, ValueSourceParameters.None>(ValueSource.class, ValueSourceParameters.class, ValueSourceParameters.None.class);
    private final InstanceGenerator paramsInstantiator;
    private final InstanceGenerator specInstantiator;

    public DefaultValueSourceProviderFactory(ListenerManager listenerManager, InstantiatorFactory instantiatorFactory, IsolatableFactory isolatableFactory, GradleProperties gradleProperties, CalculatedValueFactory calculatedValueFactory, ExecOperations execOperations, ServiceLookup services) {
        this.valueBroadcaster = listenerManager.createAnonymousBroadcaster(ValueSourceProviderFactory.ValueListener.class);
        this.computationBroadcaster = listenerManager.createAnonymousBroadcaster(ValueSourceProviderFactory.ComputationListener.class);
        this.instantiatorFactory = instantiatorFactory;
        this.isolatableFactory = isolatableFactory;
        this.gradleProperties = gradleProperties;
        this.calculatedValueFactory = calculatedValueFactory;
        this.execOperations = execOperations;
        this.paramsInstantiator = instantiatorFactory.decorateScheme().withServices(services).instantiator();
        this.specInstantiator = instantiatorFactory.decorateLenient(services);
    }

    @Override
    public <T, P extends ValueSourceParameters> Provider<T> createProviderOf(Class<? extends ValueSource<T, P>> valueSourceType, Action<? super ValueSourceSpec<P>> configureAction) {
        try {
            Class<P> parametersType = this.extractParametersTypeOf(valueSourceType);
            ValueSourceParameters parameters = parametersType != null ? (ValueSourceParameters)this.paramsInstantiator.newInstance(parametersType, new Object[0]) : null;
            this.configureParameters(parameters, configureAction);
            return this.instantiateValueSourceProvider(valueSourceType, parametersType, parameters);
        }
        catch (GradleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GradleException(this.couldNotCreateProviderOf(valueSourceType), (Throwable)e);
        }
    }

    @Override
    public void addValueListener(ValueSourceProviderFactory.ValueListener listener) {
        this.valueBroadcaster.add((Object)listener);
    }

    @Override
    public void removeValueListener(ValueSourceProviderFactory.ValueListener listener) {
        this.valueBroadcaster.remove((Object)listener);
    }

    @Override
    public void addComputationListener(ValueSourceProviderFactory.ComputationListener listener) {
        this.computationBroadcaster.add((Object)listener);
    }

    @Override
    public void removeComputationListener(ValueSourceProviderFactory.ComputationListener listener) {
        this.computationBroadcaster.remove((Object)listener);
    }

    @Override
    public <T, P extends ValueSourceParameters> @NonNull Provider<T> instantiateValueSourceProvider(Class<? extends ValueSource<T, P>> valueSourceType, @Nullable Class<P> parametersType, @Nullable P parameters) {
        return new ValueSourceProvider(new LazilyObtainedValue(this, valueSourceType, parametersType, parameters));
    }

    public <T, P extends ValueSourceParameters> @NonNull ValueSource<T, P> instantiateValueSource(Class<? extends ValueSource<T, P>> valueSourceType, @Nullable Class<P> parametersType, @Nullable P isolatedParameters) {
        CloseableServiceRegistry services = ServiceRegistryBuilder.builder().displayName("value source services").provider(registration -> {
            registration.add(GradleProperties.class, (Object)this.gradleProperties);
            registration.add(ExecOperations.class, (Object)this.execOperations);
            if (isolatedParameters != null) {
                registration.add(parametersType, (Object)isolatedParameters);
            }
        }).build();
        return (ValueSource)this.instantiatorFactory.injectScheme().withServices((ServiceLookup)services).instantiator().newInstance(valueSourceType, new Object[0]);
    }

    private <T, P extends ValueSourceParameters> @Nullable Class<P> extractParametersTypeOf(Class<? extends ValueSource<T, P>> valueSourceType) {
        return this.isolationScheme.parameterTypeFor(valueSourceType, 1);
    }

    private <P extends ValueSourceParameters> void configureParameters(@Nullable P parameters, Action<? super ValueSourceSpec<P>> configureAction) {
        DefaultValueSourceSpec valueSourceSpec = (DefaultValueSourceSpec)Cast.uncheckedNonnullCast((Object)this.specInstantiator.newInstance(DefaultValueSourceSpec.class, new Object[]{parameters}));
        configureAction.execute((Object)valueSourceSpec);
    }

    private <P extends ValueSourceParameters> @Nullable P isolateParameters(@Nullable P parameters) {
        return (P)((ValueSourceParameters)this.isolatableFactory.isolate(parameters).isolate());
    }

    private String couldNotCreateProviderOf(Class<?> valueSourceType) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Could not create provider for value source ");
        formatter.appendType(valueSourceType);
        formatter.append((CharSequence)".");
        return formatter.toString();
    }

    public static class ValueSourceProvider<T, P extends ValueSourceParameters>
    extends AbstractMinimalProvider<T> {
        private final LazilyObtainedValue<T, P> value;

        private ValueSourceProvider(LazilyObtainedValue<T, P> value) {
            this.value = value;
        }

        public Class<? extends ValueSource<T, P>> getValueSourceType() {
            return this.value.sourceType;
        }

        @Override
        protected String toStringNoReentrance() {
            return String.format("valueof(%s)", this.getValueSourceType().getSimpleName());
        }

        public @Nullable Class<P> getParametersType() {
            return this.value.parametersType;
        }

        public @Nullable P getParameters() {
            return this.value.parameters;
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.externalValue();
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        public boolean hasBeenObtained() {
            return this.value.hasBeenObtained();
        }

        @Override
        public @Nullable Class<T> getType() {
            return null;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<T> calculateExecutionTimeValue() {
            if (this.value.hasBeenObtained()) {
                return this.value.obtain().asExecutionTimeValue();
            }
            return ValueSupplier.ExecutionTimeValue.changingValue(this);
        }

        @Override
        protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            return this.value.obtain().asNullableValue();
        }
    }

    private static class LazilyObtainedValue<T, P extends ValueSourceParameters> {
        public final Class<? extends ValueSource<T, P>> sourceType;
        public final @Nullable Class<P> parametersType;
        public final @Nullable P parameters;
        private final CalculatedValue<@Nullable T> value;
        private final AtomicReference<ValueSource<T, P>> sourceRef = new AtomicReference();
        final /* synthetic */ DefaultValueSourceProviderFactory this$0;

        private LazilyObtainedValue(@Nullable Class<? extends ValueSource<T, P>> sourceType, @Nullable Class<P> parametersType, P parameters) {
            this.this$0 = var1_1;
            this.sourceType = sourceType;
            this.parametersType = parametersType;
            this.parameters = parameters;
            this.value = ((DefaultValueSourceProviderFactory)var1_1).calculatedValueFactory.create(Describables.of((Object)"ValueSource of type", sourceType), () -> {
                ((ValueSourceProviderFactory.ComputationListener)this.this$0.computationBroadcaster.getSource()).beforeValueObtained();
                try {
                    ValueSource<T, P> source = this.source();
                    this.sourceRef.set(source);
                    Object object = source.obtain();
                    return object;
                }
                finally {
                    ((ValueSourceProviderFactory.ComputationListener)this.this$0.computationBroadcaster.getSource()).afterValueObtained();
                }
            });
        }

        public boolean hasBeenObtained() {
            return this.value.isFinalized();
        }

        public ObtainedValueHolder<T> obtain() {
            ValueSource obtainedFrom;
            try {
                this.value.finalizeIfNotAlready();
            }
            finally {
                obtainedFrom = this.sourceRef.getAndSet(null);
            }
            Try<@Nullable T> obtained = this.value.getValue();
            if (obtainedFrom != null) {
                ((ValueSourceProviderFactory.ValueListener)this.this$0.valueBroadcaster.getSource()).valueObtained(this.obtainedValue(obtained), obtainedFrom);
                DisplayName displayName = null;
                if (obtainedFrom instanceof Describable) {
                    displayName = Describables.of((Object)((Describable)obtainedFrom).getDisplayName());
                }
                return new ObtainedValueHolder(obtained, displayName);
            }
            return new ObtainedValueHolder<T>(obtained);
        }

        private @NonNull ValueSource<T, P> source() {
            return this.this$0.instantiateValueSource(this.sourceType, this.parametersType, this.this$0.isolateParameters(this.parameters));
        }

        private @NonNull DefaultObtainedValue<T, P> obtainedValue(Try<@Nullable T> obtained) {
            return new DefaultObtainedValue<T, P>(obtained, this.sourceType, this.parametersType, this.parameters);
        }
    }

    @NonExtensible
    public static abstract class DefaultValueSourceSpec<P extends ValueSourceParameters>
    implements ValueSourceSpec<P> {
        private final P parameters;

        public DefaultValueSourceSpec(P parameters) {
            this.parameters = parameters;
        }

        public P getParameters() {
            return this.parameters;
        }

        public void parameters(Action<? super P> configureAction) {
            configureAction.execute(this.parameters);
        }
    }

    private static class DefaultObtainedValue<T, P extends ValueSourceParameters>
    implements ValueSourceProviderFactory.ValueListener.ObtainedValue<T, P> {
        private final Try<@Nullable T> value;
        private final Class<? extends ValueSource<T, P>> valueSourceType;
        private final Class<P> parametersType;
        private final @Nullable P parameters;

        public DefaultObtainedValue(Try<@Nullable T> value, Class<? extends ValueSource<T, P>> valueSourceType, @Nullable Class<P> parametersType, @Nullable P parameters) {
            this.value = value;
            this.valueSourceType = valueSourceType;
            this.parametersType = parametersType;
            this.parameters = parameters;
        }

        @Override
        public Try<@Nullable T> getValue() {
            return this.value;
        }

        @Override
        public Class<? extends ValueSource<T, P>> getValueSourceType() {
            return this.valueSourceType;
        }

        @Override
        public @Nullable Class<P> getValueSourceParametersType() {
            return this.parametersType;
        }

        @Override
        public P getValueSourceParameters() {
            return this.parameters;
        }
    }

    private static class ObtainedValueHolder<T> {
        private final Try<T> obtained;
        private final @Nullable DisplayName displayName;

        private ObtainedValueHolder(Try<T> obtained, @Nullable DisplayName displayName) {
            this.obtained = obtained;
            this.displayName = displayName;
        }

        public ObtainedValueHolder(Try<T> obtained) {
            this(obtained, null);
        }

        public ValueSupplier.Value<T> asNullableValue() {
            return ValueSupplier.Value.ofNullable(this.obtained.get()).pushWhenMissing(this.displayName);
        }

        public ValueSupplier.ExecutionTimeValue<T> asExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.ofNullable(this.obtained.get());
        }
    }
}

