/*
 * Copyright 2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.Path;

import java.io.IOException;

/**
 * A thread-safe and reusable serializer for {@link Path}.
 */
public class PathSerializer extends AbstractSerializer<Path> {

    @Override
    public Path read(Decoder decoder) throws IOException {
        boolean isRoot = decoder.readBoolean();

        if (isRoot) {
            return Path.ROOT;
        } else {
            return Path.path(decoder.readString());
        }
    }

    @Override
    public void write(Encoder encoder, Path value) throws IOException {
        boolean isRoot = value.equals(Path.ROOT);
        encoder.writeBoolean(isRoot);

        if (!isRoot) {
            encoder.writeString(value.getPath());
        }
    }

}
