/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.internal.plugins.BuildModel;
import org.gradle.api.internal.plugins.HasBuildModel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.Cast;
import org.gradle.internal.inspection.DefaultTypeParameterInspection;

public interface SoftwareFeatureApplicationContext {
    @Inject
    public ProjectLayout getProjectLayout();

    @Inject
    public Project getProject();

    @Inject
    public ObjectFactory getObjectFactory();

    default public <T extends HasBuildModel<? extends V>, V extends BuildModel> V getOrCreateModel(T definition) {
        Object existingModel;
        if (definition instanceof ExtensionAware && (existingModel = ((ExtensionAware)definition).getExtensions().findByName("model")) != null) {
            return (V)((BuildModel)Cast.uncheckedCast((Object)existingModel));
        }
        DefaultTypeParameterInspection inspection = new DefaultTypeParameterInspection(HasBuildModel.class, BuildModel.class, BuildModel.NONE.class);
        Class modelType = inspection.parameterTypeFor(definition.getClass());
        if (modelType == null) {
            throw new IllegalArgumentException("Cannot determine build model type for " + definition.getClass());
        }
        return this.getOrCreateModel(definition, modelType);
    }

    default public <T extends HasBuildModel<? extends V>, V extends BuildModel> V getOrCreateModel(T definition, Class<? extends V> implementationType) {
        return (V)((BuildModel)((ExtensionAware)definition).getExtensions().create("model", implementationType, new Object[0]));
    }
}

