/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.software.internal;

import groovy.lang.Closure;
import javax.inject.Inject;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.plugin.software.internal.SoftwareFeatureApplicator;
import org.gradle.plugin.software.internal.SoftwareFeatureRegistry;
import org.gradle.util.internal.ConfigureUtil;
import org.jspecify.annotations.Nullable;

public abstract class SoftwareFeaturesDynamicObject
extends AbstractDynamicObject {
    private final ExtensionAware target;

    @Inject
    public SoftwareFeaturesDynamicObject(ExtensionAware target) {
        this.target = target;
    }

    public String getDisplayName() {
        return "software features";
    }

    public boolean hasMethod(String name, Object ... arguments) {
        return this.isSoftwareTypeConfigureMethod(name, arguments);
    }

    private boolean isSoftwareTypeConfigureMethod(String name, @Nullable Object[] arguments) {
        return arguments != null && arguments.length == 1 && arguments[0] instanceof Closure && this.getSoftwareTypeRegistry().getSoftwareFeatureImplementations().containsKey(name);
    }

    public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
        if (this.isSoftwareTypeConfigureMethod(name, arguments)) {
            Object softwareFeatureConfigurationModel = this.getSoftwareFeatureApplicator().applyFeatureTo(this.target, this.getSoftwareTypeRegistry().getSoftwareFeatureImplementations().get(name));
            return DynamicInvokeResult.found((Object)ConfigureUtil.configure((Closure)((Closure)arguments[0]), softwareFeatureConfigurationModel));
        }
        return DynamicInvokeResult.notFound();
    }

    @Inject
    protected abstract SoftwareFeatureRegistry getSoftwareTypeRegistry();

    @Inject
    protected abstract SoftwareFeatureApplicator getSoftwareFeatureApplicator();
}

