/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import org.gradle.api.Describable;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.util.Path;
import org.jspecify.annotations.Nullable;

public final class ProjectIdentity
implements DisplayName {
    private final Path buildPath;
    private final Path projectPath;
    private final String projectName;
    private final Path buildTreePath;
    private final DisplayName displayName;

    public static Path computeProjectIdentityPath(Path buildPath, Path projectPath) {
        return buildPath.append(projectPath);
    }

    public static ProjectIdentity forRootProject(Path buildPath, String projectName) {
        return new ProjectIdentity(buildPath, Path.ROOT, projectName);
    }

    public static ProjectIdentity forSubproject(Path buildPath, Path projectPath) {
        if (projectPath.equals((Object)Path.ROOT)) {
            throw new IllegalStateException("Use ProjectIdentity.forRootProject() for the root project.");
        }
        if (!projectPath.isAbsolute()) {
            throw new IllegalArgumentException("Project path must be absolute: " + projectPath);
        }
        return new ProjectIdentity(buildPath, projectPath, projectPath.getName());
    }

    private ProjectIdentity(Path buildPath, Path projectPath, String projectName) {
        this.buildPath = buildPath;
        this.projectPath = projectPath;
        this.projectName = projectName;
        this.buildTreePath = ProjectIdentity.computeProjectIdentityPath(buildPath, projectPath);
        String prefix = Path.ROOT.equals((Object)this.buildTreePath) ? "root project" : "project";
        this.displayName = Describables.memoize((Describable)Describables.of((Object)prefix, (Object)this.buildTreePath.getPath()));
    }

    public Path getBuildPath() {
        return this.buildPath;
    }

    public Path getProjectPath() {
        return this.projectPath;
    }

    public Path getBuildTreePath() {
        return this.buildTreePath;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getDisplayName() {
        return this.displayName.getDisplayName();
    }

    public String getCapitalizedDisplayName() {
        return this.displayName.getCapitalizedDisplayName();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectIdentity that = (ProjectIdentity)o;
        return this.buildTreePath.equals((Object)that.buildTreePath);
    }

    public int hashCode() {
        return this.buildTreePath.hashCode();
    }
}

