/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.GradlePropertiesController;
import org.gradle.initialization.GradlePropertiesListener;
import org.gradle.initialization.properties.DefaultGradleProperties;
import org.gradle.initialization.properties.GradlePropertiesLoader;
import org.gradle.initialization.properties.SystemPropertiesInstaller;
import org.jspecify.annotations.Nullable;

public class DefaultGradlePropertiesController
implements GradlePropertiesController {
    private final GradlePropertiesLoader gradlePropertiesLoader;
    private final SystemPropertiesInstaller systemPropertiesInstaller;
    private final GradlePropertiesListener listener;
    private final ConcurrentMap<BuildIdentifier, BuildScopedGradleProperties> buildProperties = new ConcurrentHashMap<BuildIdentifier, BuildScopedGradleProperties>();
    private final ConcurrentMap<ProjectIdentity, ProjectScopedGradleProperties> projectProperties = new ConcurrentHashMap<ProjectIdentity, ProjectScopedGradleProperties>();

    public DefaultGradlePropertiesController(GradlePropertiesLoader gradlePropertiesLoader, SystemPropertiesInstaller systemPropertiesInstaller, GradlePropertiesListener listener) {
        this.gradlePropertiesLoader = gradlePropertiesLoader;
        this.systemPropertiesInstaller = systemPropertiesInstaller;
        this.listener = listener;
    }

    @Override
    public GradleProperties getGradleProperties(BuildIdentifier buildId) {
        return this.getOrCreateGradleProperties(buildId);
    }

    @Override
    public void loadGradleProperties(BuildIdentifier buildId, File buildRootDir, boolean setSystemProperties) {
        this.getOrCreateGradleProperties(buildId).loadProperties(buildRootDir, setSystemProperties);
    }

    @Override
    public void unloadGradleProperties(BuildIdentifier buildId) {
        if (!this.projectProperties.isEmpty()) {
            throw new IllegalStateException("Cannot unload Gradle properties after loading project properties.");
        }
        this.getOrCreateGradleProperties(buildId).unload();
    }

    @Override
    public GradleProperties getGradleProperties(ProjectIdentity projectId) {
        return this.getOrCreateGradleProperties(projectId);
    }

    @Override
    public void loadGradleProperties(ProjectIdentity projectId, File projectDir) {
        LoadedBuildScopedState loadedBuildProperties = this.getOrCreateGradleProperties(new DefaultBuildIdentifier(projectId.getBuildPath())).checkLoaded();
        this.getOrCreateGradleProperties(projectId).loadProperties(loadedBuildProperties, projectDir);
    }

    private BuildScopedGradleProperties getOrCreateGradleProperties(BuildIdentifier buildId) {
        return this.buildProperties.computeIfAbsent(buildId, id -> new BuildScopedGradleProperties(this.gradlePropertiesLoader, this.systemPropertiesInstaller, (BuildIdentifier)id, this.listener));
    }

    private ProjectScopedGradleProperties getOrCreateGradleProperties(ProjectIdentity projectId) {
        return this.projectProperties.computeIfAbsent(projectId, id -> new ProjectScopedGradleProperties(this.gradlePropertiesLoader, (ProjectIdentity)id, this.listener));
    }

    @SafeVarargs
    private static ImmutableMap<String, String> mergeMaps(Map<String, String> ... maps) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map<String, String> map : maps) {
            builder.putAll(map);
        }
        return builder.buildKeepingLast();
    }

    private static class BuildScopedGradleProperties
    extends ScopedGradleProperties {
        private final GradlePropertiesLoader loader;
        private final SystemPropertiesInstaller systemPropertiesInstaller;
        private final BuildIdentifier buildId;
        private volatile @Nullable LoadedBuildScopedState loaded;

        private BuildScopedGradleProperties(GradlePropertiesLoader loader, SystemPropertiesInstaller systemPropertiesInstaller, BuildIdentifier buildId, GradlePropertiesListener listener) {
            super(new BuildPropertyScope(buildId), listener);
            this.loader = loader;
            this.systemPropertiesInstaller = systemPropertiesInstaller;
            this.buildId = buildId;
        }

        @Override
        protected GradleProperties gradleProperties() {
            return this.checkLoaded().gradleProperties;
        }

        private LoadedBuildScopedState checkLoaded() {
            LoadedBuildScopedState loaded = this.loaded;
            if (loaded == null) {
                throw new IllegalStateException(String.format("GradleProperties for %s have not been loaded yet.", this.buildId));
            }
            return loaded;
        }

        private void loadProperties(File buildRootDir, boolean setSystemProperties) {
            LoadedBuildScopedState loaded = this.loaded;
            if (loaded != null) {
                if (loaded.buildRootDir.equals(buildRootDir)) {
                    return;
                }
                throw new IllegalStateException(String.format("GradleProperties has already been loaded from '%s' and cannot be loaded from '%s'.", loaded.buildRootDir, buildRootDir));
            }
            this.loaded = this.loadNewState(buildRootDir, setSystemProperties);
        }

        private LoadedBuildScopedState loadNewState(File buildRootDir, boolean setSystemProperties) {
            Map<String, String> fromGradleHome = this.loader.loadFromGradleHome();
            Map<String, String> fromBuildRoot = this.loader.loadFrom(buildRootDir);
            Map<String, String> fromGradleUserHome = this.loader.loadFromGradleUserHome();
            if (setSystemProperties) {
                boolean isRootBuild = DefaultBuildIdentifier.ROOT.equals(this.buildId);
                DefaultGradleProperties systemPropertiesSource = new DefaultGradleProperties((Map<String, String>)DefaultGradlePropertiesController.mergeMaps(new Map[]{fromGradleHome, fromBuildRoot, fromGradleUserHome}));
                this.systemPropertiesInstaller.setSystemPropertiesFrom(systemPropertiesSource, isRootBuild);
            }
            Map<String, String> fromEnvVariables = this.loader.loadFromEnvironmentVariables();
            Map<String, String> fromSystemProperties = this.loader.loadFromSystemProperties();
            Map<String, String> fromStartParamProjectProperties = this.loader.loadFromStartParameterProjectProperties();
            return LoadedBuildScopedState.from(buildRootDir, fromGradleHome, fromBuildRoot, fromGradleUserHome, fromEnvVariables, fromSystemProperties, fromStartParamProjectProperties);
        }

        private void unload() {
            this.loaded = null;
        }
    }

    private static class ProjectScopedGradleProperties
    extends ScopedGradleProperties {
        private final GradlePropertiesLoader loader;
        private final ProjectIdentity projectId;
        private volatile @Nullable GradleProperties loaded;

        private ProjectScopedGradleProperties(GradlePropertiesLoader loader, ProjectIdentity projectId, GradlePropertiesListener listener) {
            super(new ProjectPropertyScope(projectId), listener);
            this.loader = loader;
            this.projectId = projectId;
        }

        @Override
        protected GradleProperties gradleProperties() {
            GradleProperties loaded = this.loaded;
            if (loaded == null) {
                throw new IllegalStateException(String.format("GradleProperties for %s have not been loaded yet.", this.projectId));
            }
            return loaded;
        }

        private void loadProperties(LoadedBuildScopedState loadedBuildProperties, File projectDir) {
            if (this.loaded != null) {
                throw new IllegalStateException(String.format("GradleProperties has already been loaded for %s", this.projectId));
            }
            this.loaded = this.loadNewState(loadedBuildProperties, projectDir);
        }

        private GradleProperties loadNewState(LoadedBuildScopedState loadedBuildProperties, File projectDir) {
            Map<String, String> fromProjectDir = this.loader.loadFrom(projectDir);
            ImmutableMap projectScopedProperties = DefaultGradlePropertiesController.mergeMaps(new Map[]{loadedBuildProperties.projectScopedDefaults, fromProjectDir, loadedBuildProperties.projectScopedOverrides});
            return new DefaultGradleProperties((Map<String, String>)projectScopedProperties);
        }
    }

    private static class LoadedBuildScopedState {
        private final File buildRootDir;
        private final GradleProperties gradleProperties;
        private final Map<String, String> projectScopedDefaults;
        private final Map<String, String> projectScopedOverrides;

        private LoadedBuildScopedState(File buildRootDir, GradleProperties gradleProperties, Map<String, String> projectScopedDefaults, Map<String, String> projectScopedOverrides) {
            this.buildRootDir = buildRootDir;
            this.gradleProperties = gradleProperties;
            this.projectScopedDefaults = projectScopedDefaults;
            this.projectScopedOverrides = projectScopedOverrides;
        }

        public static LoadedBuildScopedState from(File buildRootDir, Map<String, String> fromGradleHome, Map<String, String> fromBuildRoot, Map<String, String> fromGradleUserHome, Map<String, String> fromEnvVariables, Map<String, String> fromSystemProperties, Map<String, String> fromStartParamProjectProperties) {
            ImmutableMap defaults = DefaultGradlePropertiesController.mergeMaps(new Map[]{fromGradleHome, fromBuildRoot});
            ImmutableMap overrides = DefaultGradlePropertiesController.mergeMaps(new Map[]{fromGradleUserHome, fromEnvVariables, fromSystemProperties, fromStartParamProjectProperties});
            ImmutableMap buildScopedProperties = DefaultGradlePropertiesController.mergeMaps(new Map[]{defaults, overrides});
            return new LoadedBuildScopedState(buildRootDir, new DefaultGradleProperties((Map<String, String>)buildScopedProperties), (Map<String, String>)defaults, (Map<String, String>)overrides);
        }
    }

    private static class ProjectPropertyScope
    implements GradlePropertiesListener.PropertyScope.Project {
        private final ProjectIdentity projectId;

        public ProjectPropertyScope(ProjectIdentity projectId) {
            this.projectId = projectId;
        }

        @Override
        public ProjectIdentity getProjectIdentity() {
            return this.projectId;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ProjectPropertyScope)) {
                return false;
            }
            ProjectPropertyScope that = (ProjectPropertyScope)o;
            return Objects.equals(this.projectId, that.projectId);
        }

        @Override
        public int hashCode() {
            return this.projectId.hashCode();
        }

        @Override
        public String toString() {
            return "ProjectPropertyScope{" + this.projectId + '}';
        }
    }

    private static class BuildPropertyScope
    implements GradlePropertiesListener.PropertyScope.Build {
        private final BuildIdentifier buildId;

        public BuildPropertyScope(BuildIdentifier buildId) {
            this.buildId = buildId;
        }

        @Override
        public BuildIdentifier getBuildIdentifier() {
            return this.buildId;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof BuildPropertyScope)) {
                return false;
            }
            BuildPropertyScope that = (BuildPropertyScope)o;
            return Objects.equals(this.buildId, that.buildId);
        }

        @Override
        public int hashCode() {
            return this.buildId.hashCode();
        }

        @Override
        public String toString() {
            return "BuildPropertyScope{" + this.buildId + '}';
        }
    }

    private static abstract class ScopedGradleProperties
    implements GradleProperties {
        private final GradlePropertiesListener.PropertyScope propertyScope;
        private final GradlePropertiesListener listener;

        protected ScopedGradleProperties(GradlePropertiesListener.PropertyScope propertyScope, GradlePropertiesListener listener) {
            this.propertyScope = propertyScope;
            this.listener = listener;
        }

        protected abstract GradleProperties gradleProperties();

        public @Nullable String find(String propertyName) {
            String value = this.gradleProperties().find(propertyName);
            this.onGradleProperty(propertyName, value);
            return value;
        }

        public @Nullable Object findUnsafe(String propertyName) {
            Object value = this.gradleProperties().findUnsafe(propertyName);
            this.onGradleProperty(propertyName, value);
            return value;
        }

        public Map<String, String> getProperties() {
            Map snapshot = this.gradleProperties().getProperties();
            this.onGradleProperties(snapshot);
            return snapshot;
        }

        public Map<String, String> getPropertiesWithPrefix(String prefix) {
            Map snapshot = this.gradleProperties().getPropertiesWithPrefix(prefix);
            this.listener.onGradlePropertiesByPrefix(this.propertyScope, prefix, snapshot);
            return snapshot;
        }

        private void onGradleProperties(Map<String, String> snapshot) {
            for (Map.Entry<String, String> entry : snapshot.entrySet()) {
                this.onGradleProperty(entry.getKey(), entry.getValue());
            }
        }

        private void onGradleProperty(String propertyName, @Nullable Object value) {
            this.listener.onGradlePropertyAccess(this.propertyScope, propertyName, value);
        }
    }
}

