/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Objects;
import java.util.Map;
import org.gradle.api.internal.provider.DefaultListProperty;
import org.gradle.api.internal.provider.DefaultMapProperty;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.provider.DefaultSetProperty;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.internal.Cast;
import org.gradle.internal.state.ManagedFactory;
import org.jspecify.annotations.Nullable;

public class ManagedFactories {

    public static class MapPropertyManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = MapProperty.class;
        private static final Class<?> IMPL_TYPE = MapProperty.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{IMPL_TYPE.getName()});
        private final PropertyFactory propertyFactory;

        public MapPropertyManagedFactory(PropertyFactory propertyFactory) {
            this.propertyFactory = propertyFactory;
        }

        public <S> @Nullable S fromState(Class<S> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            DefaultMapProperty<Object, Object> property = this.propertyFactory.mapProperty(Object.class, Object.class);
            property.set((Map)Cast.uncheckedNonnullCast((Object)state));
            return type.cast(property);
        }

        @Override
        public int getId() {
            return FACTORY_ID;
        }
    }

    public static class SetPropertyManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = SetProperty.class;
        private static final Class<?> IMPL_TYPE = DefaultSetProperty.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{IMPL_TYPE.getName()});
        private final PropertyFactory propertyFactory;

        public SetPropertyManagedFactory(PropertyFactory propertyFactory) {
            this.propertyFactory = propertyFactory;
        }

        @Override
        public <T> @Nullable T fromState(Class<T> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            DefaultSetProperty<Object> property = this.propertyFactory.setProperty(Object.class);
            property.set((Iterable)Cast.uncheckedNonnullCast((Object)state));
            return type.cast(property);
        }

        @Override
        public int getId() {
            return FACTORY_ID;
        }
    }

    public static class ListPropertyManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = ListProperty.class;
        private static final Class<?> IMPL_TYPE = DefaultListProperty.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{IMPL_TYPE.getName()});
        private final PropertyFactory propertyFactory;

        public ListPropertyManagedFactory(PropertyFactory propertyFactory) {
            this.propertyFactory = propertyFactory;
        }

        public <S> @Nullable S fromState(Class<S> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            DefaultListProperty<Object> property = this.propertyFactory.listProperty(Object.class);
            property.set((Iterable)Cast.uncheckedNonnullCast((Object)state));
            return type.cast(property);
        }

        @Override
        public int getId() {
            return FACTORY_ID;
        }
    }

    public static class PropertyManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = Property.class;
        private static final Class<?> IMPL_TYPE = DefaultProperty.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{IMPL_TYPE.getName()});
        private final PropertyFactory propertyFactory;

        public PropertyManagedFactory(PropertyFactory propertyFactory) {
            this.propertyFactory = propertyFactory;
        }

        public <S> @Nullable S fromState(Class<S> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            ProviderInternal provider = (ProviderInternal)Cast.uncheckedNonnullCast((Object)state);
            Class providerType = provider.getType();
            if (providerType == null) {
                DefaultProperty<?> noTypeProperty = this.propertyFactory.propertyWithNoType();
                return type.cast(noTypeProperty);
            }
            return type.cast(this.propertyOf(providerType, provider));
        }

        <V> Property<V> propertyOf(Class<V> type, Provider<V> value) {
            return this.propertyFactory.property(type).value(value);
        }

        @Override
        public int getId() {
            return FACTORY_ID;
        }
    }

    public static class ProviderManagedFactory
    implements ManagedFactory {
        private static final Class<?> PUBLIC_TYPE = Provider.class;
        private static final Class<?> IMPL_TYPE = Providers.FixedValueProvider.class;
        public static final int FACTORY_ID = Objects.hashCode((Object[])new Object[]{IMPL_TYPE.getName()});

        @Override
        public <T> @Nullable T fromState(Class<T> type, Object state) {
            if (!type.isAssignableFrom(PUBLIC_TYPE)) {
                return null;
            }
            return type.cast(Providers.ofNullable(state));
        }

        @Override
        public int getId() {
            return FACTORY_ID;
        }
    }
}

