/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.properties;

import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.Environment;
import org.gradle.initialization.properties.ProjectPropertiesLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProjectPropertiesLoader
implements ProjectPropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProjectPropertiesLoader.class);
    private final Environment environment;
    private final StartParameterInternal startParameter;

    public DefaultProjectPropertiesLoader(StartParameterInternal startParameter, Environment environment) {
        this.environment = environment;
        this.startParameter = startParameter;
    }

    @Override
    public Map<String, String> loadProjectProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(this.projectPropertiesFromEnvironmentVariables());
        properties.putAll(this.projectPropertiesFromSystemProperties());
        properties.putAll(this.startParameter.getProjectProperties());
        return properties;
    }

    private Map<String, String> projectPropertiesFromSystemProperties() {
        Map<String, String> systemProjectProperties = DefaultProjectPropertiesLoader.byPrefix("org.gradle.project.", this.environment.getSystemProperties());
        LOGGER.debug("Found system project properties: {}", systemProjectProperties.keySet());
        return systemProjectProperties;
    }

    private Map<String, String> projectPropertiesFromEnvironmentVariables() {
        Map<String, String> envProjectProperties = DefaultProjectPropertiesLoader.byPrefix("ORG_GRADLE_PROJECT_", this.environment.getVariables());
        LOGGER.debug("Found env project properties: {}", envProjectProperties.keySet());
        return envProjectProperties;
    }

    private static Map<String, String> byPrefix(String prefix, Environment.Properties properties) {
        return DefaultProjectPropertiesLoader.mapKeysRemovingPrefix(prefix, properties.byNamePrefix(prefix));
    }

    private static Map<String, String> mapKeysRemovingPrefix(String prefix, Map<String, String> mapWithPrefix) {
        HashMap<String, String> mapWithoutPrefix = new HashMap<String, String>(mapWithPrefix.size());
        for (Map.Entry<String, String> entry : mapWithPrefix.entrySet()) {
            mapWithoutPrefix.put(entry.getKey().substring(prefix.length()), entry.getValue());
        }
        return mapWithoutPrefix;
    }
}

