/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.initialization.properties.MutableGradleProperties;
import org.jspecify.annotations.Nullable;

public class DefaultGradleProperties
implements MutableGradleProperties {
    private final Map<String, String> defaultProperties;
    private final Map<String, String> overrideProperties;
    private ImmutableMap<String, String> gradleProperties;

    public DefaultGradleProperties(Map<String, String> defaultProperties, Map<String, String> overrideProperties) {
        this.defaultProperties = defaultProperties;
        this.overrideProperties = overrideProperties;
        this.gradleProperties = this.mergePropertiesWith((Map<String, String>)ImmutableMap.of());
    }

    public @Nullable String find(String propertyName) {
        return (String)this.gradleProperties.get((Object)propertyName);
    }

    public Map<String, String> mergeProperties(Map<String, String> properties) {
        return properties.isEmpty() ? this.gradleProperties : this.mergePropertiesWith(properties);
    }

    @Override
    public void updateOverrideProperties(Map<String, String> properties) {
        this.overrideProperties.putAll(properties);
        this.gradleProperties = this.mergePropertiesWith((Map<String, String>)ImmutableMap.of());
    }

    public Map<String, String> getProperties() {
        return this.gradleProperties;
    }

    private ImmutableMap<String, String> mergePropertiesWith(Map<String, String> properties) {
        return ImmutableMap.builder().putAll(this.defaultProperties).putAll(properties).putAll(this.overrideProperties).buildKeepingLast();
    }
}

