/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.maven;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.AbstractLazyModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.DefaultConfigurationMetadata;
import org.gradle.internal.component.external.model.ExternalModuleVariantGraphResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.external.model.maven.DefaultMutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.MavenDependencyMetadata;
import org.gradle.internal.component.external.model.maven.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.RealisedMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DefaultMavenModuleResolveMetadata
extends AbstractLazyModuleComponentResolveMetadata
implements MavenModuleResolveMetadata {
    public static final String POM_PACKAGING = "pom";
    static final Set<String> JAR_PACKAGINGS = ImmutableSet.of((Object)"jar", (Object)"ejb", (Object)"bundle", (Object)"maven-plugin", (Object)"eclipse-plugin");
    private final NamedObjectInstantiator objectInstantiator;
    private final AttributesFactory attributesFactory;
    private final ImmutableList<MavenDependencyDescriptor> dependencies;
    private final String packaging;
    private final boolean relocated;
    private final String snapshotTimestamp;
    private ImmutableList<? extends ModuleConfigurationMetadata> derivedVariants;
    private boolean filterConstraints = true;
    private MavenDependencyDescriptor[] dependenciesAsArray;

    DefaultMavenModuleResolveMetadata(DefaultMutableMavenModuleResolveMetadata metadata) {
        super(metadata);
        this.objectInstantiator = metadata.getObjectInstantiator();
        this.attributesFactory = metadata.getAttributesFactory();
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
        this.dependencies = metadata.getDependencies();
    }

    private DefaultMavenModuleResolveMetadata(DefaultMavenModuleResolveMetadata metadata, ModuleSources sources, VariantDerivationStrategy derivationStrategy) {
        super(metadata, sources, derivationStrategy);
        this.objectInstantiator = metadata.objectInstantiator;
        this.attributesFactory = metadata.attributesFactory;
        this.packaging = metadata.packaging;
        this.relocated = metadata.relocated;
        this.snapshotTimestamp = metadata.snapshotTimestamp;
        this.dependencies = metadata.dependencies;
        this.copyCachedState(metadata, metadata.getVariantDerivationStrategy() != derivationStrategy);
    }

    @Override
    protected DefaultConfigurationMetadata createConfiguration(ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableSet<String> parents, VariantMetadataRules componentMetadataRules) {
        ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts = this.getArtifactsForConfiguration();
        DefaultConfigurationMetadata configuration = new DefaultConfigurationMetadata(componentId, name, transitive, visible, parents, artifacts, componentMetadataRules, (ImmutableList<ExcludeMetadata>)ImmutableList.of(), this.getAttributes(), false);
        configuration.setConfigDependenciesFactory((Factory<List<ModuleDependencyMetadata>>)((Factory)() -> this.filterDependencies(configuration)));
        return configuration;
    }

    @Override
    protected Optional<List<? extends ExternalModuleVariantGraphResolveMetadata>> maybeDeriveVariants() {
        return Optional.ofNullable(this.getDerivedVariants());
    }

    protected Optional<List<? extends ModuleConfigurationMetadata>> deriveVariants() {
        return Optional.ofNullable(this.getDerivedVariants());
    }

    private ImmutableList<? extends ModuleConfigurationMetadata> getDerivedVariants() {
        VariantDerivationStrategy strategy = this.getVariantDerivationStrategy();
        if (this.derivedVariants == null && strategy.derivesVariants()) {
            this.filterConstraints = false;
            this.derivedVariants = strategy.derive(this);
        }
        return this.derivedVariants;
    }

    @Override
    protected ModuleConfigurationMetadata populateConfigurationFromDescriptor(String name, Map<String, Configuration> configurationDefinitions) {
        DefaultConfigurationMetadata md = (DefaultConfigurationMetadata)super.populateConfigurationFromDescriptor(name, configurationDefinitions);
        if (this.filterConstraints && md != null) {
            return md.mutate().withoutConstraints().build();
        }
        return md;
    }

    private ImmutableList<? extends ModuleComponentArtifactMetadata> getArtifactsForConfiguration() {
        return RealisedMavenModuleResolveMetadata.getArtifactsForConfiguration(this);
    }

    private ImmutableList<ModuleDependencyMetadata> filterDependencies(DefaultConfigurationMetadata config) {
        if (this.dependencies.isEmpty()) {
            return ImmutableList.of();
        }
        int size = this.dependencies.size();
        if (this.dependenciesAsArray == null) {
            this.dependenciesAsArray = (MavenDependencyDescriptor[])this.dependencies.toArray((Object[])new MavenDependencyDescriptor[0]);
        }
        ImmutableList.Builder filteredDependencies = null;
        boolean isOptionalConfiguration = "optional".equals(config.getName());
        ImmutableSet<String> hierarchy = config.getHierarchy();
        for (MavenDependencyDescriptor dependency : this.dependenciesAsArray) {
            MavenDependencyMetadata element;
            if (isOptionalConfiguration && this.includeInOptionalConfiguration(dependency)) {
                element = new OptionalConfigurationMavenDependencyMetadata(dependency);
                if (size == 1) {
                    return ImmutableList.of((Object)element);
                }
                if (filteredDependencies == null) {
                    filteredDependencies = ImmutableList.builder();
                }
                filteredDependencies.add((Object)element);
                continue;
            }
            if (!this.include(dependency, (Collection<String>)hierarchy)) continue;
            element = new MavenDependencyMetadata(dependency);
            if (size == 1) {
                return ImmutableList.of((Object)element);
            }
            if (filteredDependencies == null) {
                filteredDependencies = ImmutableList.builder();
            }
            filteredDependencies.add((Object)element);
        }
        return filteredDependencies == null ? ImmutableList.of() : filteredDependencies.build();
    }

    private boolean includeInOptionalConfiguration(MavenDependencyDescriptor dependency) {
        MavenScope dependencyScope = dependency.getScope();
        return dependency.isOptional() && dependencyScope != MavenScope.Test && dependencyScope != MavenScope.System;
    }

    private boolean include(MavenDependencyDescriptor dependency, Collection<String> hierarchy) {
        if (dependency.isOptional()) {
            return false;
        }
        return hierarchy.contains(dependency.getScope().getLowerName());
    }

    @Override
    public MutableMavenModuleResolveMetadata asMutable() {
        return new DefaultMutableMavenModuleResolveMetadata(this, this.objectInstantiator);
    }

    @Override
    public DefaultMavenModuleResolveMetadata withSources(ModuleSources sources) {
        return new DefaultMavenModuleResolveMetadata(this, sources, this.getVariantDerivationStrategy());
    }

    @Override
    public ModuleComponentResolveMetadata withDerivationStrategy(VariantDerivationStrategy derivationStrategy) {
        if (this.getVariantDerivationStrategy() == derivationStrategy) {
            return this;
        }
        return new DefaultMavenModuleResolveMetadata(this, this.getSources(), derivationStrategy);
    }

    @Override
    public @NonNull String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public boolean isPomPackaging() {
        return POM_PACKAGING.equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return JAR_PACKAGINGS.contains(this.packaging);
    }

    public NamedObjectInstantiator getObjectInstantiator() {
        return this.objectInstantiator;
    }

    @Override
    public @Nullable String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    public ImmutableList<MavenDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultMavenModuleResolveMetadata that = (DefaultMavenModuleResolveMetadata)o;
        return this.relocated == that.relocated && Objects.equal(this.dependencies, that.dependencies) && Objects.equal((Object)this.packaging, (Object)that.packaging) && Objects.equal((Object)this.snapshotTimestamp, (Object)that.snapshotTimestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.dependencies, this.packaging, this.relocated, this.snapshotTimestamp});
    }

    private static class OptionalConfigurationMavenDependencyMetadata
    extends MavenDependencyMetadata {
        OptionalConfigurationMavenDependencyMetadata(MavenDependencyDescriptor delegate) {
            super(delegate);
        }

        @Override
        public List<IvyArtifactName> getArtifacts() {
            IvyArtifactName dependencyArtifact = this.getDependencyDescriptor().getDependencyArtifact();
            return dependencyArtifact == null ? ImmutableList.of() : ImmutableList.of((Object)dependencyArtifact);
        }

        @Override
        public boolean isConstraint() {
            return false;
        }
    }
}

