/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.StartParameter;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessorFactory;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.LegacyResolutionParameters;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.capability.CapabilitySelectorSerializer;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyLockingState;
import org.gradle.api.internal.artifacts.ivyservice.DefaultLenientConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResolvedConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.InMemoryResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.ResolutionParameters;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ExternalModuleComponentResolverFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolverProviderFactories;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ResolverProviderFactory;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentRegistry;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolversChain;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.DependencyGraphResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultResolvedArtifactsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DefaultVisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSetResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactsGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VariantArtifactSetCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.CompositeDependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.CompositeDependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.DefaultVisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.DefaultResolvedConfigurationBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolutionFailureCollector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.ResolvedConfigurationDependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AdhocHandlingComponentResultSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.StreamingResolutionResultBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.ResolutionResultsStoreFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.store.StoreSet;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.artifacts.result.ResolvedComponentResultInternal;
import org.gradle.api.internal.artifacts.transform.ConsumerProvidedVariantFinder;
import org.gradle.api.internal.artifacts.transform.DefaultTransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.immutable.artifact.ImmutableArtifactTypeRegistry;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.cache.internal.BinaryStore;
import org.gradle.cache.internal.Store;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.LocalComponentDependencyMetadata;
import org.gradle.internal.component.resolution.failure.ResolutionFailureHandler;
import org.gradle.internal.locking.DependencyLockingGraphVisitor;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.resolve.resolver.ResolvedVariantCache;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Project.class})
public class ResolutionExecutor {
    private static final Spec<DependencyMetadata> IS_LOCAL_EDGE = element -> element.getSelector() instanceof ProjectComponentSelector;
    private final DependencyGraphResolver dependencyGraphResolver;
    private final ResolutionResultsStoreFactory storeFactory;
    private final boolean buildProjectDependencies;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final BuildOperationExecutor buildOperationExecutor;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ComponentSelectorConverter componentSelectorConverter;
    private final AttributeContainerSerializer attributeContainerSerializer;
    private final CapabilitySelectorSerializer capabilitySelectorSerializer;
    private final ResolvedArtifactSetResolver artifactSetResolver;
    private final ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory;
    private final AdhocHandlingComponentResultSerializer componentResultSerializer;
    private final ResolvedVariantCache resolvedVariantCache;
    private final GraphVariantSelector graphVariantSelector;
    private final LocalComponentRegistry localComponentRegistry;
    private final List<ResolverProviderFactory> resolverFactories;
    private final ExternalModuleComponentResolverFactory externalResolverFactory;
    private final ProjectDependencyResolver projectDependencyResolver;
    private final DependencyLockingProvider dependencyLockingProvider;
    private final TransformedVariantFactory transformedVariantFactory;
    private final AttributesFactory attributesFactory;
    private final DomainObjectContext domainObjectContext;
    private final TaskDependencyFactory taskDependencyFactory;
    private final ConsumerProvidedVariantFinder consumerProvidedVariantFinder;
    private final AttributeSchemaServices attributeSchemaServices;
    private final ResolutionFailureHandler resolutionFailureHandler;
    private final VariantArtifactSetCache variantArtifactSetCache;
    private final VariantTransformRegistry transformRegistry;
    private final ComponentMetadataProcessorFactory componentMetadataProcessorFactory;

    @Inject
    public ResolutionExecutor(DependencyGraphResolver dependencyGraphResolver, ResolutionResultsStoreFactory storeFactory, StartParameter startParameter, ImmutableModuleIdentifierFactory moduleIdentifierFactory, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory, ComponentSelectorConverter componentSelectorConverter, AttributeContainerSerializer attributeContainerSerializer, CapabilitySelectorSerializer capabilitySelectorSerializer, ResolvedArtifactSetResolver artifactSetResolver, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, AdhocHandlingComponentResultSerializer componentResultSerializer, ResolvedVariantCache resolvedVariantCache, GraphVariantSelector graphVariantSelector, LocalComponentRegistry localComponentRegistry, ResolverProviderFactories resolverFactories, ExternalModuleComponentResolverFactory externalResolverFactory, ProjectDependencyResolver projectDependencyResolver, DependencyLockingProvider dependencyLockingProvider, TransformedVariantFactory transformedVariantFactory, AttributesFactory attributesFactory, DomainObjectContext domainObjectContext, TaskDependencyFactory taskDependencyFactory, ConsumerProvidedVariantFinder consumerProvidedVariantFinder, AttributeSchemaServices attributeSchemaServices, ResolutionFailureHandler resolutionFailureHandler, VariantArtifactSetCache variantArtifactSetCache, VariantTransformRegistry transformRegistry, ComponentMetadataProcessorFactory componentMetadataProcessorFactory) {
        this.dependencyGraphResolver = dependencyGraphResolver;
        this.storeFactory = storeFactory;
        this.buildProjectDependencies = startParameter.isBuildProjectDependencies();
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.buildOperationExecutor = buildOperationExecutor;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.componentSelectorConverter = componentSelectorConverter;
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.capabilitySelectorSerializer = capabilitySelectorSerializer;
        this.artifactSetResolver = artifactSetResolver;
        this.componentSelectionDescriptorFactory = componentSelectionDescriptorFactory;
        this.componentResultSerializer = componentResultSerializer;
        this.resolvedVariantCache = resolvedVariantCache;
        this.graphVariantSelector = graphVariantSelector;
        this.localComponentRegistry = localComponentRegistry;
        this.resolverFactories = resolverFactories.getFactories();
        this.externalResolverFactory = externalResolverFactory;
        this.projectDependencyResolver = projectDependencyResolver;
        this.dependencyLockingProvider = dependencyLockingProvider;
        this.transformedVariantFactory = transformedVariantFactory;
        this.attributesFactory = attributesFactory;
        this.domainObjectContext = domainObjectContext;
        this.taskDependencyFactory = taskDependencyFactory;
        this.consumerProvidedVariantFinder = consumerProvidedVariantFinder;
        this.attributeSchemaServices = attributeSchemaServices;
        this.resolutionFailureHandler = resolutionFailureHandler;
        this.variantArtifactSetCache = variantArtifactSetCache;
        this.transformRegistry = transformRegistry;
        this.componentMetadataProcessorFactory = componentMetadataProcessorFactory;
    }

    public ResolverResults resolveBuildDependencies(LegacyResolutionParameters legacyParams, ResolutionParameters params, CalculatedValue<ResolverResults> futureCompleteResults) {
        ResolutionFailureCollector failureCollector = new ResolutionFailureCollector(this.componentSelectorConverter, this.domainObjectContext);
        InMemoryResolutionResultBuilder resolutionResultBuilder = new InMemoryResolutionResultBuilder(params.getIncludeAllSelectableVariantResults());
        DefaultResolvedArtifactsBuilder artifactsBuilder = new DefaultResolvedArtifactsBuilder(this.buildProjectDependencies);
        ComponentResolvers resolvers = this.getResolvers(params, legacyParams, Collections.emptyList());
        ResolvedArtifactsGraphVisitor artifactsGraphVisitor = this.artifactVisitorFor(artifactsBuilder, params.getArtifactTypeRegistry());
        ImmutableList visitors = ImmutableList.of((Object)failureCollector, (Object)resolutionResultBuilder, (Object)artifactsGraphVisitor);
        this.doResolve(params, legacyParams, (ImmutableList<ResolutionParameters.ModuleVersionLock>)ImmutableList.of(), resolvers, IS_LOCAL_EDGE, (ImmutableList<DependencyGraphVisitor>)visitors);
        Set<UnresolvedDependency> unresolvedDependencies = failureCollector.complete(Collections.emptySet());
        DefaultVisitedGraphResults graphResults = new DefaultVisitedGraphResults(resolutionResultBuilder.getResolutionResult(), unresolvedDependencies);
        VisitedArtifactResults artifactsResults = artifactsBuilder.complete();
        TransformUpstreamDependenciesResolver.Factory dependenciesResolverFactory = visitedArtifacts -> new DefaultTransformUpstreamDependenciesResolver(params.getResolutionHost(), params.getConfigurationIdentity(), params.getRootVariant().getAttributes(), params.getDefaultSortOrder(), graphResults, visitedArtifacts, futureCompleteResults, this.domainObjectContext, this.calculatedValueContainerFactory, this.attributesFactory, this.taskDependencyFactory);
        VisitedArtifactSet visitedArtifacts2 = this.getVisitedArtifactSet(params, resolvers, graphResults, artifactsResults, dependenciesResolverFactory);
        return DefaultResolverResults.buildDependenciesResolved(graphResults, visitedArtifacts2, DefaultResolverResults.DefaultLegacyResolverResults.buildDependenciesResolved());
    }

    public ResolverResults resolveGraph(LegacyResolutionParameters legacyParams, ResolutionParameters params, List<ResolutionAwareRepository> repositories) {
        StoreSet stores = this.storeFactory.createStoreSet();
        BinaryStore oldModelStore = stores.nextBinaryStore();
        Store<TransientConfigurationResults> oldModelCache = stores.oldModelCache();
        TransientConfigurationResultsBuilder oldTransientModelBuilder = new TransientConfigurationResultsBuilder(oldModelStore, oldModelCache, this.moduleIdentifierFactory, this.buildOperationExecutor, params.getResolutionHost());
        DefaultResolvedConfigurationBuilder oldModelBuilder = new DefaultResolvedConfigurationBuilder(oldTransientModelBuilder);
        ResolvedConfigurationDependencyGraphVisitor oldModelVisitor = new ResolvedConfigurationDependencyGraphVisitor(oldModelBuilder);
        BinaryStore newModelStore = stores.nextBinaryStore();
        Store<ResolvedComponentResultInternal> newModelCache = stores.newModelCache();
        StreamingResolutionResultBuilder newModelBuilder = new StreamingResolutionResultBuilder(newModelStore, newModelCache, this.attributeContainerSerializer, this.capabilitySelectorSerializer, this.componentResultSerializer, this.componentSelectionDescriptorFactory, params.getIncludeAllSelectableVariantResults());
        DefaultResolvedArtifactsBuilder artifactsBuilder = new DefaultResolvedArtifactsBuilder(this.buildProjectDependencies);
        ResolutionFailureCollector failureCollector = new ResolutionFailureCollector(this.componentSelectorConverter, this.domainObjectContext);
        ImmutableList.Builder graphVisitors = ImmutableList.builder();
        graphVisitors.add((Object)newModelBuilder);
        graphVisitors.add((Object)failureCollector);
        DependencyLockingGraphVisitor lockingVisitor = null;
        if (params.isDependencyLockingEnabled()) {
            lockingVisitor = new DependencyLockingGraphVisitor(params.getDependencyLockingId(), params.getResolutionHost().displayName(), this.dependencyLockingProvider);
            graphVisitors.add((Object)lockingVisitor);
        } else {
            this.dependencyLockingProvider.confirmNotLocked(params.getDependencyLockingId());
        }
        ComponentResolvers resolvers = this.getResolvers(params, legacyParams, repositories);
        CompositeDependencyArtifactsVisitor artifactVisitors = new CompositeDependencyArtifactsVisitor((List<DependencyArtifactsVisitor>)ImmutableList.of((Object)oldModelVisitor, (Object)artifactsBuilder));
        graphVisitors.add((Object)this.artifactVisitorFor(artifactVisitors, params.getArtifactTypeRegistry()));
        this.doResolve(params, legacyParams, this.getAllVersionLocks(params), resolvers, (Spec<DependencyMetadata>)Specs.satisfyAll(), (ImmutableList<DependencyGraphVisitor>)graphVisitors.build());
        VisitedArtifactResults artifactsResults = artifactsBuilder.complete();
        Set<UnresolvedDependency> lockingFailures = Collections.emptySet();
        if (lockingVisitor != null) {
            lockingFailures = lockingVisitor.collectLockingFailures();
        }
        Set<UnresolvedDependency> resolutionFailures = failureCollector.complete(lockingFailures);
        MinimalResolutionResult resolutionResult = newModelBuilder.getResolutionResult(lockingFailures);
        DefaultVisitedGraphResults graphResults = new DefaultVisitedGraphResults(resolutionResult, resolutionFailures);
        if (lockingVisitor != null && !graphResults.hasAnyFailure()) {
            lockingVisitor.writeLocks();
        }
        TransformUpstreamDependenciesResolver.Factory dependenciesResolverFactory = visitedArtifacts -> new DefaultTransformUpstreamDependenciesResolver(params.getResolutionHost(), params.getConfigurationIdentity(), params.getRootVariant().getAttributes(), params.getDefaultSortOrder(), graphResults, visitedArtifacts, this.domainObjectContext, this.calculatedValueContainerFactory, this.attributesFactory, this.taskDependencyFactory);
        VisitedArtifactSet visitedArtifacts2 = this.getVisitedArtifactSet(params, resolvers, graphResults, artifactsResults, dependenciesResolverFactory);
        DefaultLenientConfiguration lenientConfiguration = new DefaultLenientConfiguration(params.getResolutionHost(), graphResults, visitedArtifacts2, oldTransientModelBuilder::load, this.artifactSetResolver, ResolutionExecutor.getImplicitSelectionSpec(params));
        DefaultResolvedConfiguration configuration = new DefaultResolvedConfiguration(graphResults, params.getResolutionHost(), visitedArtifacts2, lenientConfiguration);
        return DefaultResolverResults.graphResolved(graphResults, visitedArtifacts2, DefaultResolverResults.DefaultLegacyResolverResults.graphResolved(configuration));
    }

    private static ArtifactSelectionSpec getImplicitSelectionSpec(ResolutionParameters params) {
        ImmutableAttributes requestAttributes = params.getRootVariant().getAttributes();
        ResolutionStrategy.SortOrder sortOrder = params.getDefaultSortOrder();
        return new ArtifactSelectionSpec(requestAttributes, (Spec<? super ComponentIdentifier>)Specs.satisfyAll(), false, false, sortOrder);
    }

    private ResolvedArtifactsGraphVisitor artifactVisitorFor(DependencyArtifactsVisitor artifactsVisitor, ImmutableArtifactTypeRegistry immutableArtifactTypeRegistry) {
        return new ResolvedArtifactsGraphVisitor(artifactsVisitor, immutableArtifactTypeRegistry, this.variantArtifactSetCache, this.calculatedValueContainerFactory);
    }

    private VisitedArtifactSet getVisitedArtifactSet(ResolutionParameters params, ComponentResolvers resolvers, VisitedGraphResults graphResults, VisitedArtifactResults artifactsResults, TransformUpstreamDependenciesResolver.Factory dependenciesResolverFactory) {
        ImmutableAttributesSchema consumerSchema = params.getRootComponent().getMetadata().getAttributesSchema();
        return new DefaultVisitedArtifactSet(graphResults, params.getResolutionHost(), artifactsResults, this.artifactSetResolver, this.transformedVariantFactory, dependenciesResolverFactory, consumerSchema, this.consumerProvidedVariantFinder, this.attributesFactory, this.attributeSchemaServices, this.resolutionFailureHandler, resolvers.getArtifactResolver(), params.getArtifactTypeRegistry(), this.resolvedVariantCache, this.graphVariantSelector, this.transformRegistry);
    }

    private void doResolve(ResolutionParameters params, LegacyResolutionParameters legacyParams, ImmutableList<ResolutionParameters.ModuleVersionLock> moduleVersionLocks, ComponentResolvers resolvers, Spec<DependencyMetadata> edgeFilter, ImmutableList<DependencyGraphVisitor> visitors) {
        ImmutableList.Builder syntheticDependencies = ImmutableList.builderWithExpectedSize((int)moduleVersionLocks.size());
        for (ResolutionParameters.ModuleVersionLock lock : moduleVersionLocks) {
            syntheticDependencies.add((Object)ResolutionExecutor.asDependencyConstraintMetadata(lock));
        }
        this.dependencyGraphResolver.resolve(params.getRootComponent(), params.getRootVariant(), (List<? extends DependencyMetadata>)syntheticDependencies.build(), edgeFilter, this.componentSelectorConverter, resolvers.getComponentIdResolver(), resolvers.getComponentResolver(), params.getModuleReplacements(), legacyParams.getDependencySubstitutionRules(), params.getModuleConflictResolutionStrategy(), legacyParams.getCapabilityConflictResolutionRules(), params.isFailingOnDynamicVersions(), params.isFailingOnChangingVersions(), params.getFailureResolutions(), new CompositeDependencyGraphVisitor((List<DependencyGraphVisitor>)visitors));
    }

    private ComponentResolvers getResolvers(ResolutionParameters params, LegacyResolutionParameters legacyParams, List<ResolutionAwareRepository> repositories) {
        ArrayList<ComponentResolvers> resolvers = new ArrayList<ComponentResolvers>(3);
        for (ResolverProviderFactory factory : this.resolverFactories) {
            factory.create(resolvers, this.localComponentRegistry);
        }
        resolvers.add(this.projectDependencyResolver);
        resolvers.add(this.externalResolverFactory.createResolvers(repositories, this.componentMetadataProcessorFactory, legacyParams.getComponentSelectionRules(), params.isDependencyVerificationEnabled(), params.getCacheExpirationControl(), params.getRootComponent().getMetadata().getAttributesSchema()));
        return new ComponentResolversChain(resolvers);
    }

    private ImmutableList<ResolutionParameters.ModuleVersionLock> getAllVersionLocks(ResolutionParameters params) {
        if (!params.isDependencyLockingEnabled()) {
            return params.getModuleVersionLocks();
        }
        if (params.isFailingOnDynamicVersions()) {
            throw new InvalidUserCodeException("Both dependency locking and fail on dynamic versions are enabled. You must choose between the two modes.");
        }
        if (params.isFailingOnChangingVersions()) {
            throw new InvalidUserCodeException("Both dependency locking and fail on changing versions are enabled. You must choose between the two modes.");
        }
        return ImmutableList.builder().addAll(this.getLockfileLocks(params)).addAll(params.getModuleVersionLocks()).build();
    }

    private ImmutableList<ResolutionParameters.ModuleVersionLock> getLockfileLocks(ResolutionParameters params) {
        DependencyLockingState dependencyLockingState = this.dependencyLockingProvider.loadLockState(params.getDependencyLockingId(), params.getResolutionHost().displayName());
        boolean strict = dependencyLockingState.mustValidateLockState();
        Set<ModuleComponentIdentifier> lockedDependencies = dependencyLockingState.getLockedDependencies();
        ImmutableList.Builder locks = ImmutableList.builderWithExpectedSize((int)lockedDependencies.size());
        for (ModuleComponentIdentifier lockedDependency : lockedDependencies) {
            locks.add((Object)new ResolutionParameters.ModuleVersionLock(lockedDependency.getModuleIdentifier(), lockedDependency.getVersion(), "Dependency version enforced by Dependency Locking", strict));
        }
        return locks.build();
    }

    private static LocalComponentDependencyMetadata asDependencyConstraintMetadata(ResolutionParameters.ModuleVersionLock lock) {
        ImmutableVersionConstraint versionConstraint = lock.isStrict() ? DefaultImmutableVersionConstraint.strictly(lock.getVersion()) : DefaultImmutableVersionConstraint.of(lock.getVersion());
        ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector(lock.getModuleId(), versionConstraint);
        return new LocalComponentDependencyMetadata((ComponentSelector)selector, null, Collections.emptyList(), Collections.emptyList(), false, false, false, true, false, true, lock.getReason());
    }
}

