/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.sources;

import org.gradle.api.Incubating;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.AbstractLanguageSourceSet;
import org.gradle.platform.base.ModelInstantiationException;
import org.gradle.platform.base.internal.ComponentSpecIdentifier;

@Incubating
public class BaseLanguageSourceSet
extends AbstractLanguageSourceSet {
    protected final ObjectFactory objectFactory;
    private static final ThreadLocal<SourceSetInfo> NEXT_SOURCE_SET_INFO = new ThreadLocal();

    public static <T extends LanguageSourceSet> T create(Class<? extends LanguageSourceSet> publicType, Class<T> implementationType, ComponentSpecIdentifier componentId, ObjectFactory objectFactory) {
        NEXT_SOURCE_SET_INFO.set(new SourceSetInfo(componentId, publicType, objectFactory));
        try {
            LanguageSourceSet languageSourceSet = (LanguageSourceSet)objectFactory.newInstance(implementationType, new Object[0]);
            return (T)languageSourceSet;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create LanguageSourceSet of type %s", publicType.getSimpleName()), e.getCause());
        }
        finally {
            NEXT_SOURCE_SET_INFO.set(null);
        }
    }

    public BaseLanguageSourceSet() {
        this(NEXT_SOURCE_SET_INFO.get());
    }

    private BaseLanguageSourceSet(SourceSetInfo info) {
        super(BaseLanguageSourceSet.validate(info).identifier, info.publicType, info.objectFactory.sourceDirectorySet("source", "source"));
        this.objectFactory = info.objectFactory;
    }

    private static SourceSetInfo validate(SourceSetInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseLanguageSourceSet is not permitted. Use a @ComponentType rule instead.");
        }
        return info;
    }

    private static class SourceSetInfo {
        private final ComponentSpecIdentifier identifier;
        private final Class<? extends LanguageSourceSet> publicType;
        private final ObjectFactory objectFactory;

        private SourceSetInfo(ComponentSpecIdentifier identifier, Class<? extends LanguageSourceSet> publicType, ObjectFactory objectFactory) {
            this.identifier = identifier;
            this.publicType = publicType;
            this.objectFactory = objectFactory;
        }
    }
}

