/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.composite.internal.BuildTreeWorkGraphController;
import org.gradle.execution.plan.ExecutionNodeAccessHierarchies;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.NodeValidator;
import org.gradle.execution.plan.ResolveMutationsNode;
import org.gradle.execution.plan.TaskInAnotherBuild;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.Cast;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.impl.DefaultWorkValidationContext;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.plugin.use.PluginId;
import org.gradle.plugin.use.internal.DefaultPluginId;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.Build.class})
public class TaskNodeFactory {
    private final Map<Task, TaskNode> nodes = new ConcurrentHashMap<Task, TaskNode>();
    private final BuildTreeWorkGraphController workGraphController;
    private final InternalProblems problems;
    private final GradleInternal thisBuild;
    private final DefaultTypeOriginInspectorFactory typeOriginInspectorFactory;
    private final Function<LocalTaskNode, ResolveMutationsNode> resolveMutationsNodeFactory;

    public TaskNodeFactory(GradleInternal thisBuild, BuildTreeWorkGraphController workGraphController, NodeValidator nodeValidator, BuildOperationRunner buildOperationRunner, ExecutionNodeAccessHierarchies accessHierarchies, InternalProblems problems) {
        this.thisBuild = thisBuild;
        this.workGraphController = workGraphController;
        this.problems = problems;
        this.typeOriginInspectorFactory = new DefaultTypeOriginInspectorFactory();
        this.resolveMutationsNodeFactory = localTaskNode -> new ResolveMutationsNode((LocalTaskNode)localTaskNode, nodeValidator, buildOperationRunner, accessHierarchies);
    }

    public Set<Task> getTasks() {
        return this.nodes.keySet();
    }

    public @Nullable TaskNode getNode(Task task) {
        return this.nodes.get(task);
    }

    public TaskNode getOrCreateNode(Task task) {
        return this.nodes.computeIfAbsent(task, it -> this.createTaskNode((TaskInternal)Cast.uncheckedNonnullCast((Object)it)));
    }

    private TaskNode createTaskNode(TaskInternal task) {
        boolean sameBuild = ((ProjectInternal)task.getProject()).getGradle().getIdentityPath().equals((Object)this.thisBuild.getIdentityPath());
        if (sameBuild) {
            return new LocalTaskNode(task, (WorkValidationContext)new DefaultWorkValidationContext((WorkValidationContext.TypeOriginInspector)this.typeOriginInspectorFactory.forTask(task), this.problems), this.resolveMutationsNodeFactory);
        }
        return TaskInAnotherBuild.of(task, this.workGraphController);
    }

    public void resetState() {
        this.typeOriginInspectorFactory.resetState();
        this.nodes.clear();
    }

    private static class DefaultTypeOriginInspectorFactory {
        private final Map<Project, ProjectScopedTypeOriginInspector> projectToInspector = new ConcurrentHashMap<Project, ProjectScopedTypeOriginInspector>();
        private final Map<Class<?>, File> clazzToFile = new ConcurrentHashMap();

        private DefaultTypeOriginInspectorFactory() {
        }

        public ProjectScopedTypeOriginInspector forTask(Task task) {
            return this.projectToInspector.computeIfAbsent(task.getProject(), x$0 -> new ProjectScopedTypeOriginInspector((Project)x$0));
        }

        void resetState() {
            this.projectToInspector.clear();
        }

        private @Nullable File jarFileFor(Class<?> pluginClass) {
            return this.clazzToFile.computeIfAbsent(pluginClass, clazz -> DefaultTypeOriginInspectorFactory.toFile(pluginClass.getProtectionDomain().getCodeSource().getLocation()));
        }

        private static @Nullable File toFile(@Nullable URL url) {
            if (url == null) {
                return null;
            }
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        private class ProjectScopedTypeOriginInspector
        implements WorkValidationContext.TypeOriginInspector {
            private final PluginContainer plugins;
            private final PluginManagerInternal pluginManager;
            private final Map<Class<?>, Optional<PluginId>> classToPlugin = new ConcurrentHashMap();

            private ProjectScopedTypeOriginInspector(Project project) {
                this.plugins = project.getPlugins();
                this.pluginManager = (PluginManagerInternal)project.getPluginManager();
            }

            public Optional<PluginId> findPluginDefining(Class<?> type) {
                return this.classToPlugin.computeIfAbsent(type, clazz -> {
                    File taskJar = DefaultTypeOriginInspectorFactory.this.jarFileFor(type);
                    return this.plugins.stream().map(plugin -> (Class)Cast.uncheckedNonnullCast(plugin.getClass())).filter(pluginType -> Objects.equals(DefaultTypeOriginInspectorFactory.this.jarFileFor(pluginType), taskJar)).map(pluginType -> this.pluginManager.findPluginIdForClass(pluginType).orElseGet(() -> new DefaultPluginId(pluginType.getName()))).findFirst();
                });
            }
        }
    }
}

