/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.resolver;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.attributes.immutable.artifact.ImmutableArtifactTypeRegistry;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jspecify.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
public class ResolvedVariantCache
implements HoldsProjectState {
    private final Map<CacheKey, ResolvedVariant> cache = new ConcurrentHashMap<CacheKey, ResolvedVariant>();

    public void discardAll() {
        this.cache.clear();
    }

    public @Nullable ResolvedVariant get(CacheKey key) {
        return this.cache.get(key);
    }

    public ResolvedVariant computeIfAbsent(CacheKey key, Function<CacheKey, ResolvedVariant> mappingFunction) {
        return this.cache.computeIfAbsent(key, mappingFunction);
    }

    public static class CacheKey {
        final VariantResolveMetadata.Identifier variantIdentifier;
        final ImmutableArtifactTypeRegistry artifactTypeRegistry;
        private final int hashCode;

        public CacheKey(VariantResolveMetadata.Identifier variantIdentifier, ImmutableArtifactTypeRegistry artifactTypeRegistry) {
            this.variantIdentifier = variantIdentifier;
            this.artifactTypeRegistry = artifactTypeRegistry;
            this.hashCode = CacheKey.computeHashCode(variantIdentifier, artifactTypeRegistry);
        }

        private static int computeHashCode(VariantResolveMetadata.Identifier variantIdentifier, ImmutableArtifactTypeRegistry artifactTypeRegistry) {
            return 31 * variantIdentifier.hashCode() + artifactTypeRegistry.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.variantIdentifier.equals(other.variantIdentifier) && this.artifactTypeRegistry == other.artifactTypeRegistry;
        }
    }
}

