/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal.resolver;

import java.io.File;
import java.util.Set;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.LatestVersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelectorScheme;
import org.gradle.vcs.internal.VersionControlRepositoryConnection;
import org.gradle.vcs.internal.VersionRef;
import org.gradle.vcs.internal.resolver.PersistentVcsMetadataCache;
import org.gradle.vcs.internal.resolver.VcsVersionSelectionCache;
import org.gradle.vcs.internal.resolver.VcsVersionWorkingDirResolver;
import org.jspecify.annotations.Nullable;

public class DefaultVcsVersionWorkingDirResolver
implements VcsVersionWorkingDirResolver {
    private final VersionSelectorScheme versionSelectorScheme;
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;
    private final VcsVersionSelectionCache inMemoryCache;
    private final PersistentVcsMetadataCache persistentCache;

    public DefaultVcsVersionWorkingDirResolver(VersionSelectorScheme versionSelectorScheme, VersionComparator versionComparator, VersionParser versionParser, VcsVersionSelectionCache inMemoryCache, PersistentVcsMetadataCache persistentCache) {
        this.versionSelectorScheme = versionSelectorScheme;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
        this.inMemoryCache = inMemoryCache;
        this.persistentCache = persistentCache;
    }

    @Override
    public @Nullable File selectVersion(ModuleComponentSelector selector, VersionControlRepositoryConnection repository) {
        VersionRef selectedVersion = this.selectVersionFromRepository(repository, selector.getVersionConstraint());
        if (selectedVersion == null) {
            return null;
        }
        File workingDir = this.prepareWorkingDir(repository, selectedVersion);
        this.persistentCache.putVersionForSelector(repository, selector.getVersionConstraint(), selectedVersion);
        return workingDir;
    }

    private File prepareWorkingDir(VersionControlRepositoryConnection repository, VersionRef selectedVersion) {
        File workingDir = this.inMemoryCache.getWorkingDirForRevision(repository, selectedVersion);
        if (workingDir == null) {
            workingDir = repository.populate(selectedVersion);
            this.inMemoryCache.putWorkingDirForRevision(repository, selectedVersion, workingDir);
        }
        return workingDir;
    }

    private VersionRef selectVersionFromRepository(VersionControlRepositoryConnection repository, VersionConstraint constraint) {
        if (constraint.getBranch() != null) {
            return repository.getBranch(constraint.getBranch());
        }
        String version = constraint.getRequiredVersion();
        VersionSelector versionSelector = this.versionSelectorScheme.parseSelector(version);
        if (versionSelector instanceof LatestVersionSelector && ((LatestVersionSelector)versionSelector).getSelectorStatus().equals("integration")) {
            return repository.getDefaultBranch();
        }
        if (versionSelector.requiresMetadata()) {
            return null;
        }
        Set<VersionRef> versions = this.inMemoryCache.getVersionsForRepo(repository);
        if (versions == null) {
            versions = repository.getAvailableVersions();
            this.inMemoryCache.putVersionsForRepo(repository, versions);
        }
        Version bestVersion = null;
        VersionRef bestCandidate = null;
        for (VersionRef candidate : versions) {
            Version candidateVersion = this.versionParser.transform(candidate.getVersion());
            if (!versionSelector.accept(candidateVersion) || bestCandidate != null && this.versionComparator.asVersionComparator().compare(candidateVersion, bestVersion) <= 0) continue;
            bestVersion = candidateVersion;
            bestCandidate = candidate;
        }
        return bestCandidate;
    }
}

