/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.dependents.internal;

import java.util.Set;
import org.gradle.api.reporting.dependents.internal.DependentComponentsRenderer;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolver;
import org.gradle.reporting.ReportRenderer;
import org.jspecify.annotations.Nullable;

public class TextDependentComponentsReportRenderer
extends TextReportRenderer {
    private final DependentComponentsRenderer dependentComponentsRenderer;

    public TextDependentComponentsReportRenderer(@Nullable DependentBinariesResolver dependentBinariesResolver, boolean showNonBuildable, boolean showTestSuites) {
        this.dependentComponentsRenderer = new DependentComponentsRenderer(dependentBinariesResolver, showNonBuildable, showTestSuites);
    }

    public void renderComponents(Set<ComponentSpec> components) {
        if (components.isEmpty()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Info).println((Object)"No components.");
            return;
        }
        for (ComponentSpec component : components) {
            this.getBuilder().item((Object)component, (ReportRenderer)this.dependentComponentsRenderer);
        }
    }

    public void renderLegend() {
        this.dependentComponentsRenderer.printLegend(this.getBuilder());
    }
}

