/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

class LoggingEvictionListener
implements RemovalListener<Object, Object> {
    private static final String EVICTION_MITIGATION_MESSAGE = "\nPerformance may suffer from in-memory cache misses. Increase max heap size of Gradle build process to reduce cache misses.";
    private final AtomicInteger evictionCounter = new AtomicInteger(0);
    private final String cacheId;
    private final int maxSize;
    private final int logInterval;
    private final Logger logger;
    private Cache<Object, Object> cache;

    LoggingEvictionListener(String cacheId, int maxSize, Logger logger) {
        this.cacheId = cacheId;
        this.maxSize = maxSize;
        this.logInterval = maxSize / 10;
        this.logger = logger;
    }

    public void setCache(Cache<Object, Object> cache) {
        this.cache = cache;
    }

    public void onRemoval(RemovalNotification<Object, Object> notification) {
        if (notification.getCause() == RemovalCause.SIZE) {
            if (this.evictionCounter.get() % this.logInterval == 0) {
                this.logger.info("Cache entries evicted. In-memory cache of {}: Size{{}} MaxSize{{}}, {} {}", new Object[]{this.cacheId, this.cache.size(), this.maxSize, this.cache.stats(), EVICTION_MITIGATION_MESSAGE});
            }
            this.evictionCounter.incrementAndGet();
        }
    }
}

