import gradlebuild.integrationtests.tasks.IntegrationTest

/*
 * Copyright 2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

plugins {
    // TODO Can we apply less here?
    id("gradlebuild.internal.java")
}

val testRepo = configurations.dependencyScope("testRepo")
val resolveTestRepo = configurations.resolvable("resolveTestRepo") {
    attributes {
        attribute(Category.CATEGORY_ATTRIBUTE, project.objects.named("gradle-local-repository"))
    }
    extendsFrom(testRepo.get())
}

dependencies {
    testRepo(projects.publicApi)
    integTestDistributionRuntimeOnly(projects.distributionsJvm)
}

abstract class IntegTestCommandLineArgumentProvider(
) : CommandLineArgumentProvider {
    @get:InputDirectory
    @get:PathSensitive(PathSensitivity.RELATIVE)
    abstract val repoLocation: DirectoryProperty

    @get:Input
    abstract val kotlinVersion: Property<String>

    override fun asArguments() =
        listOf(
            "-DintegTest.apiJarRepoLocation=${repoLocation.get().asFile.absolutePath}",
            "-DintegTest.kotlinVersion=${kotlinVersion.get()}"
        )
}

tasks.withType<IntegrationTest>() {
    val argument = objects.newInstance(IntegTestCommandLineArgumentProvider::class.java).apply {
        repoLocation.fileProvider(resolveTestRepo.flatMap { it.elements }.map { it.first().asFile })
        kotlinVersion = libs.kotlinVersion
    }
    jvmArgumentProviders.add(argument)
}
tasks.isolatedProjectsIntegTest {
    enabled = false
}
