/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.async;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.AsyncStoppable;

public class ServiceLifecycle
implements AsyncStoppable {
    private final String displayName;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Map<Thread, Integer> usages = new HashMap<Thread, Integer>();
    private State state = State.RUNNING;

    public ServiceLifecycle(String displayName) {
        this.displayName = displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void use(Runnable runnable) {
        Integer depth;
        this.lock.lock();
        try {
            switch (this.state) {
                case RUNNING: {
                    break;
                }
                case STOPPING: {
                    throw new IllegalStateException(String.format("Cannot use %s as it is currently stopping.", this.displayName));
                }
                case STOPPED: {
                    throw new IllegalStateException(String.format("Cannot use %s as it has been stopped.", this.displayName));
                }
            }
            depth = this.usages.get(Thread.currentThread());
            if (depth == null) {
                this.usages.put(Thread.currentThread(), 1);
            } else {
                this.usages.put(Thread.currentThread(), depth + 1);
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            runnable.run();
        }
        finally {
            this.lock.lock();
            try {
                depth = this.usages.remove(Thread.currentThread());
                if (depth > 1) {
                    this.usages.put(Thread.currentThread(), depth - 1);
                }
                if (this.usages.isEmpty()) {
                    this.condition.signalAll();
                    if (this.state == State.STOPPING) {
                        this.state = State.STOPPED;
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void requestStop() {
        this.lock.lock();
        try {
            if (this.state == State.RUNNING) {
                this.state = this.usages.isEmpty() ? State.STOPPED : State.STOPPING;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.lock.lock();
        try {
            if (this.usages.containsKey(Thread.currentThread())) {
                throw new IllegalStateException(String.format("Cannot stop %s from a thread that is using it.", this.displayName));
            }
            if (this.state == State.RUNNING) {
                this.state = State.STOPPING;
            }
            while (!this.usages.isEmpty()) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            if (this.state != State.STOPPED) {
                this.state = State.STOPPED;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static enum State {
        RUNNING,
        STOPPING,
        STOPPED;

    }
}

