/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.codecs.core;

import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionBackedFileCollection;
import org.gradle.api.internal.artifacts.transform.TransformedArtifactSet;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.FilteredFileCollection;
import org.gradle.api.internal.file.SubtractingFileCollection;
import org.gradle.api.internal.file.collections.FailingFileCollection;
import org.gradle.api.internal.file.collections.ProviderBackedFileCollection;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.serialize.codecs.core.AbstractVisitor;
import org.gradle.internal.serialize.codecs.core.FilteredFileCollectionSpec;
import org.gradle.internal.serialize.codecs.core.ProviderBackedFileCollectionSpec;
import org.gradle.internal.serialize.codecs.core.ResolutionContentsCollectingVisitor;
import org.gradle.internal.serialize.codecs.core.SubtractingFileCollectionSpec;
import org.gradle.internal.serialize.graph.codecs.BeanSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001d\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/gradle/internal/serialize/codecs/core/CollectingVisitor;", "Lorg/gradle/internal/serialize/codecs/core/AbstractVisitor;", "<init>", "()V", "elements", "", "", "getElements", "()Ljava/util/Set;", "startVisit", "", "source", "Lorg/gradle/api/internal/file/FileCollectionInternal$Source;", "fileCollection", "Lorg/gradle/api/internal/file/FileCollectionInternal;", "prepareForVisit", "Lorg/gradle/api/internal/file/FileCollectionStructureVisitor$VisitType;", "visitCollection", "", "contents", "", "Ljava/io/File;", "core-serialization-codecs"})
@SourceDebugExtension(value={"SMAP\nFileCollectionCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileCollectionCodec.kt\norg/gradle/internal/serialize/codecs/core/CollectingVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
final class CollectingVisitor
extends AbstractVisitor {
    @NotNull
    private final Set<Object> elements = new LinkedHashSet();

    @NotNull
    public final Set<Object> getElements() {
        return this.elements;
    }

    public boolean startVisit(@NotNull FileCollectionInternal.Source source, @NotNull FileCollectionInternal fileCollection) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)fileCollection, (String)"fileCollection");
        FileCollectionInternal fileCollectionInternal = fileCollection;
        if (fileCollectionInternal instanceof SubtractingFileCollection) {
            AbstractFileCollection abstractFileCollection = ((SubtractingFileCollection)fileCollection).getLeft();
            Intrinsics.checkNotNullExpressionValue((Object)abstractFileCollection, (String)"getLeft(...)");
            FileCollection fileCollection2 = (FileCollection)abstractFileCollection;
            FileCollection fileCollection3 = ((SubtractingFileCollection)fileCollection).getRight();
            Intrinsics.checkNotNullExpressionValue((Object)fileCollection3, (String)"getRight(...)");
            this.elements.add(new SubtractingFileCollectionSpec(fileCollection2, fileCollection3));
            bl = false;
        } else if (fileCollectionInternal instanceof FilteredFileCollection) {
            FileCollectionInternal fileCollectionInternal2 = ((FilteredFileCollection)fileCollection).getCollection();
            Intrinsics.checkNotNullExpressionValue((Object)fileCollectionInternal2, (String)"getCollection(...)");
            FileCollection fileCollection4 = (FileCollection)fileCollectionInternal2;
            Spec spec = ((FilteredFileCollection)fileCollection).getFilterSpec();
            Intrinsics.checkNotNullExpressionValue((Object)spec, (String)"getFilterSpec(...)");
            this.elements.add(new FilteredFileCollectionSpec(fileCollection4, (Spec<? super File>)spec));
            bl = false;
        } else if (fileCollectionInternal instanceof ProviderBackedFileCollection) {
            ProviderInternal providerInternal = ((ProviderBackedFileCollection)fileCollection).getProvider();
            Intrinsics.checkNotNullExpressionValue((Object)providerInternal, (String)"getProvider(...)");
            ProviderInternal provider = providerInternal;
            if (!(provider instanceof TaskProvider)) {
                PathToFileResolver pathToFileResolver = ((ProviderBackedFileCollection)fileCollection).getResolver();
                Intrinsics.checkNotNullExpressionValue((Object)pathToFileResolver, (String)"getResolver(...)");
                this.elements.add(new ProviderBackedFileCollectionSpec(pathToFileResolver, provider));
                bl = false;
            } else {
                bl = true;
            }
        } else if (fileCollectionInternal instanceof FileTreeInternal) {
            this.elements.add(fileCollection);
            bl = false;
        } else if (fileCollectionInternal instanceof FailingFileCollection) {
            this.elements.add(new BeanSpec((Object)fileCollection));
            bl = false;
        } else if (fileCollectionInternal instanceof ResolutionBackedFileCollection) {
            String string = ((ResolutionBackedFileCollection)fileCollection).getResolutionHost().getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
            String displayName = string;
            boolean lenient = ((ResolutionBackedFileCollection)fileCollection).isLenient();
            ResolutionContentsCollectingVisitor nestedVisitor = new ResolutionContentsCollectingVisitor(displayName, lenient);
            ((ResolutionBackedFileCollection)fileCollection).visitStructure((FileCollectionStructureVisitor)nestedVisitor);
            nestedVisitor.addElements(this.elements);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @NotNull
    public FileCollectionStructureVisitor.VisitType prepareForVisit(@NotNull FileCollectionInternal.Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(!(source instanceof TransformedArtifactSet))) {
            boolean bl = false;
            String string = "Found artifact set " + source + " but was not expecting an artifact set";
            throw new IllegalArgumentException(string.toString());
        }
        return FileCollectionStructureVisitor.VisitType.Visit;
    }

    public void visitCollection(@NotNull FileCollectionInternal.Source source, @NotNull Iterable<? extends File> contents) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        CollectionsKt.addAll((Collection)this.elements, contents);
    }
}

