/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.ExternalResourceCachePolicy;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.cache.internal.ProducerGuard;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceReadResult;
import org.gradle.internal.resource.ExternalResourceRepository;
import org.gradle.internal.resource.cached.CachedExternalResource;
import org.gradle.internal.resource.cached.CachedExternalResourceIndex;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.LocallyAvailableResourceCandidates;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaDataCompare;
import org.gradle.internal.resource.transfer.CacheAwareExternalResourceAccessor;
import org.gradle.internal.resource.transfer.DownloadAction;
import org.gradle.util.internal.BuildCommencedTimeProvider;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheAwareExternalResourceAccessor
implements CacheAwareExternalResourceAccessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCacheAwareExternalResourceAccessor.class);
    private final ExternalResourceRepository delegate;
    private final CachedExternalResourceIndex<String> cachedExternalResourceIndex;
    private final BuildCommencedTimeProvider timeProvider;
    private final TemporaryFileProvider temporaryFileProvider;
    private final ArtifactCacheLockingAccessCoordinator cacheAccessCoordinator;
    private final ExternalResourceCachePolicy externalResourceCachePolicy;
    private final ProducerGuard<ExternalResourceName> producerGuard;
    private final FileResourceRepository fileResourceRepository;
    private final ChecksumService checksumService;

    public DefaultCacheAwareExternalResourceAccessor(ExternalResourceRepository delegate, CachedExternalResourceIndex<String> cachedExternalResourceIndex, BuildCommencedTimeProvider timeProvider, TemporaryFileProvider temporaryFileProvider, ArtifactCacheLockingAccessCoordinator cacheAccessCoordinator, ExternalResourceCachePolicy externalResourceCachePolicy, ProducerGuard<ExternalResourceName> producerGuard, FileResourceRepository fileResourceRepository, ChecksumService checksumService) {
        this.delegate = delegate;
        this.cachedExternalResourceIndex = cachedExternalResourceIndex;
        this.timeProvider = timeProvider;
        this.temporaryFileProvider = temporaryFileProvider;
        this.cacheAccessCoordinator = cacheAccessCoordinator;
        this.externalResourceCachePolicy = externalResourceCachePolicy;
        this.producerGuard = producerGuard;
        this.fileResourceRepository = fileResourceRepository;
        this.checksumService = checksumService;
    }

    @Override
    public @Nullable LocallyAvailableExternalResource getResource(ExternalResourceName location, @Nullable String baseName, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, @Nullable LocallyAvailableResourceCandidates additionalCandidates) {
        return (LocallyAvailableExternalResource)this.producerGuard.guardByKey((Object)location, () -> {
            boolean hasLocalCandidates;
            boolean isUnchanged;
            LOGGER.debug("Constructing external resource: {}", (Object)location);
            CachedExternalResource cached = this.cachedExternalResourceIndex.lookup(location.toString());
            if (cached == null && (additionalCandidates == null || additionalCandidates.isNone())) {
                return this.copyToCache(location, fileStore, this.delegate.withProgressLogging().resource(location));
            }
            if (cached != null && !this.externalResourceCachePolicy.mustRefreshExternalResource(this.getAgeMillis(this.timeProvider, cached))) {
                return this.fileResourceRepository.resource(cached.getCachedFile(), location.getUri(), cached.getExternalResourceMetaData());
            }
            boolean revalidate = true;
            ExternalResourceMetaData remoteMetaData = this.delegate.resource(location, true).getMetaData();
            if (remoteMetaData == null) {
                return null;
            }
            if (cached != null && (isUnchanged = ExternalResourceMetaDataCompare.isDefinitelyUnchanged((ExternalResourceMetaData)cached.getExternalResourceMetaData(), () -> remoteMetaData))) {
                LOGGER.info("Cached resource {} is up-to-date (lastModified: {}).", (Object)location, (Object)cached.getExternalLastModified());
                this.cachedExternalResourceIndex.store(location.toString(), cached.getCachedFile(), cached.getExternalResourceMetaData());
                return this.fileResourceRepository.resource(cached.getCachedFile(), location.getUri(), cached.getExternalResourceMetaData());
            }
            boolean bl = hasLocalCandidates = additionalCandidates != null && !additionalCandidates.isNone();
            if (hasLocalCandidates) {
                LocallyAvailableResource local;
                HashCode remoteChecksum = remoteMetaData.getSha1();
                if (remoteChecksum == null) {
                    remoteChecksum = this.getResourceSha1(location, true);
                }
                if (remoteChecksum != null && (local = additionalCandidates.findByHashValue(remoteChecksum)) != null) {
                    LocallyAvailableExternalResource resource;
                    LOGGER.info("Found locally available resource with matching checksum: [{}, {}]", (Object)location, (Object)local.getFile());
                    try {
                        resource = this.copyCandidateToCache(location, fileStore, remoteMetaData, remoteChecksum, local);
                    }
                    catch (IOException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                    if (resource != null) {
                        return resource;
                    }
                }
            }
            return this.copyToCache(location, fileStore, this.delegate.withProgressLogging().resource(location, true));
        });
    }

    private @Nullable HashCode getResourceSha1(ExternalResourceName location, boolean revalidate) {
        try {
            ExternalResourceName sha1Location = location.append(".sha1");
            ExternalResource resource = this.delegate.resource(sha1Location, revalidate);
            ExternalResourceReadResult result = resource.withContentIfPresent(inputStream -> {
                String sha = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.US_ASCII);
                sha = StringUtils.leftPad((String)sha, (int)Hashing.sha1().getHexDigits(), (char)'0');
                return HashCode.fromString((String)sha);
            });
            return result == null ? null : (HashCode)result.getResult();
        }
        catch (Exception e) {
            LOGGER.debug(String.format("Failed to download SHA1 for resource '%s'.", location), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable LocallyAvailableExternalResource copyCandidateToCache(ExternalResourceName source, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, ExternalResourceMetaData remoteMetaData, HashCode remoteChecksum, LocallyAvailableResource local) throws IOException {
        File destination = this.temporaryFileProvider.createTemporaryFile("gradle_download", "bin", new String[0]);
        try {
            Files.copy((File)local.getFile(), (File)destination);
            HashCode localChecksum = this.checksumService.sha1(destination);
            if (!localChecksum.equals((Object)remoteChecksum)) {
                LocallyAvailableExternalResource locallyAvailableExternalResource = null;
                return locallyAvailableExternalResource;
            }
            LocallyAvailableExternalResource locallyAvailableExternalResource = this.moveIntoCache(source, destination, fileStore, remoteMetaData);
            return locallyAvailableExternalResource;
        }
        finally {
            destination.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable LocallyAvailableExternalResource copyToCache(ExternalResourceName source, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, ExternalResource resource) {
        DownloadAction downloadAction = new DownloadAction(source, this.temporaryFileProvider, LOGGER);
        resource.withContentIfPresent((ExternalResource.ContentAndMetadataAction)downloadAction);
        if (downloadAction.getMetaData() == null) {
            return null;
        }
        try {
            LocallyAvailableExternalResource locallyAvailableExternalResource = this.moveIntoCache(source, downloadAction.getDestination(), fileStore, downloadAction.getMetaData());
            return locallyAvailableExternalResource;
        }
        finally {
            downloadAction.getDestination().delete();
        }
    }

    private LocallyAvailableExternalResource moveIntoCache(ExternalResourceName source, File destination, CacheAwareExternalResourceAccessor.ResourceFileStore fileStore, ExternalResourceMetaData metaData) {
        return (LocallyAvailableExternalResource)this.cacheAccessCoordinator.useCache(() -> {
            LocallyAvailableResource cachedResource = fileStore.moveIntoCache(destination);
            File fileInFileStore = cachedResource.getFile();
            this.cachedExternalResourceIndex.store(source.toString(), fileInFileStore, metaData);
            return this.fileResourceRepository.resource(fileInFileStore, source.getUri(), metaData);
        });
    }

    private long getAgeMillis(BuildCommencedTimeProvider timeProvider, CachedExternalResource cached) {
        return timeProvider.getCurrentTime() - cached.getCachedAt();
    }
}

