/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import groovy.lang.Closure;
import java.io.File;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileCollectionObservationListener;
import org.gradle.api.internal.file.collections.FileTreeAdapter;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSetFactory;
import org.gradle.internal.file.PathToFileResolver;

public class DefaultConfigurableFileTree
extends CompositeFileTree
implements ConfigurableFileTree {
    private Object dir;
    private final PatternSet patternSet;
    private final PathToFileResolver resolver;
    private final DefaultTaskDependency buildDependency;
    private final FileCollectionObservationListener listener;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;

    public DefaultConfigurableFileTree(PathToFileResolver resolver, FileCollectionObservationListener listener, PatternSetFactory patternSetFactory, TaskDependencyFactory taskDependencyFactory, DirectoryFileTreeFactory directoryFileTreeFactory) {
        super(taskDependencyFactory);
        this.resolver = resolver;
        this.listener = listener;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.patternSet = patternSetFactory.createPatternSet();
        this.buildDependency = taskDependencyFactory.configurableDependency();
    }

    @Override
    public Set<File> getFiles() {
        this.listener.fileCollectionObserved(this);
        return super.getFiles();
    }

    @Override
    public boolean isEmpty() {
        this.listener.fileCollectionObserved(this);
        return super.isEmpty();
    }

    @Override
    public boolean contains(File file) {
        this.listener.fileCollectionObserved(this);
        return super.contains(file);
    }

    @Override
    public FileTree visit(FileVisitor visitor) {
        this.listener.fileCollectionObserved(this);
        return super.visit(visitor);
    }

    public PatternSet getPatterns() {
        return this.patternSet;
    }

    public DefaultConfigurableFileTree setDir(Object dir) {
        this.from(dir);
        return this;
    }

    public File getDir() {
        if (this.dir == null) {
            throw new InvalidUserDataException("A base directory must be specified in the task or via a method argument!");
        }
        return this.resolver.resolve(this.dir);
    }

    public DefaultConfigurableFileTree from(Object dir) {
        this.dir = dir;
        return this;
    }

    @Override
    public String getDisplayName() {
        return "directory '" + this.dir + "'";
    }

    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    public DefaultConfigurableFileTree setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes(includes);
        return this;
    }

    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    public DefaultConfigurableFileTree setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes(excludes);
        return this;
    }

    public DefaultConfigurableFileTree include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    public DefaultConfigurableFileTree include(Iterable<String> includes) {
        this.patternSet.include(includes);
        return this;
    }

    public DefaultConfigurableFileTree include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public DefaultConfigurableFileTree include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    public DefaultConfigurableFileTree exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public DefaultConfigurableFileTree exclude(Iterable<String> excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    public DefaultConfigurableFileTree exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    public DefaultConfigurableFileTree exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        File dir = this.getDir();
        visitor.accept(new FileTreeAdapter(this.directoryFileTreeFactory.create(dir, this.patternSet), this.listener, this.taskDependencyFactory, this.patternSetFactory));
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)this.buildDependency);
    }

    public ConfigurableFileTree builtBy(Object ... tasks) {
        this.buildDependency.add(tasks);
        return this;
    }

    public Set<Object> getBuiltBy() {
        return this.buildDependency.getMutableValues();
    }

    public ConfigurableFileTree setBuiltBy(Iterable<?> tasks) {
        this.buildDependency.setValues(tasks);
        return this;
    }

    public PathToFileResolver getResolver() {
        return this.resolver;
    }
}

