/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.properties;

import java.util.Map;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.EnvironmentChangeTracker;
import org.gradle.initialization.properties.SystemPropertiesInstaller;
import org.gradle.internal.Cast;

public class DefaultSystemPropertiesInstaller
implements SystemPropertiesInstaller {
    private final EnvironmentChangeTracker environmentChangeTracker;
    private final StartParameterInternal startParameter;

    public DefaultSystemPropertiesInstaller(EnvironmentChangeTracker environmentChangeTracker, StartParameterInternal startParameter) {
        this.environmentChangeTracker = environmentChangeTracker;
        this.startParameter = startParameter;
    }

    @Override
    public void setSystemPropertiesFrom(GradleProperties gradleProperties, boolean isRootBuild) {
        this.setSystemPropertiesFromGradleProperties(gradleProperties, isRootBuild);
        this.setSystemPropertiesFromStartParameter();
    }

    private void setSystemPropertiesFromStartParameter() {
        Map systemPropertiesArgs = this.startParameter.getSystemPropertiesArgs();
        for (String key : systemPropertiesArgs.keySet()) {
            this.environmentChangeTracker.systemPropertyOverridden(key);
        }
        System.getProperties().putAll((Map<?, ?>)systemPropertiesArgs);
    }

    private void setSystemPropertiesFromGradleProperties(GradleProperties properties, boolean isRootBuild) {
        String prefix = "systemProp.";
        int prefixLength = prefix.length();
        Map prefixedProperties = properties.getPropertiesWithPrefix(prefix);
        for (Map.Entry entry : prefixedProperties.entrySet()) {
            String prefixedPropertyName = (String)entry.getKey();
            String systemPropertyKey = prefixedPropertyName.substring(prefixLength);
            String propertyValue = (String)entry.getValue();
            if (!isRootBuild) {
                this.environmentChangeTracker.systemPropertyLoaded(systemPropertyKey, propertyValue, System.getProperty(systemPropertyKey));
            }
            System.setProperty(systemPropertyKey, (String)Cast.uncheckedNonnullCast((Object)propertyValue));
        }
    }
}

