/*
 * Copyright 2017 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.caching.http.internal

import org.gradle.integtests.fixtures.AbstractIntegrationSpec
import org.gradle.test.fixtures.server.http.HttpBuildCacheServer
import org.junit.Rule

class HttpBuildCacheFixture extends AbstractIntegrationSpec {

    @Rule
    HttpBuildCacheServer httpBuildCacheServer = new HttpBuildCacheServer(temporaryFolder)

    String withHttpBuildCacheServer() {
        httpBuildCacheServer.start()
        return useHttpBuildCache(httpBuildCacheServer.uri)
    }

    static String useHttpBuildCache(URI uri) {
        """
            buildCache {
                local {
                    enabled = false
                }
                remote(HttpBuildCache) {
                    url = "${uri}"
                    push = true
                }
            }
        """
    }
}
