/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Named;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.NamedVariantIdentifier;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.dependencies.SelfResolvingDependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyMetadataFactory;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalVariantGraphResolveStateBuilder;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesEntry;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.DefaultLocalVariantGraphResolveMetadata;
import org.gradle.internal.component.local.model.DefaultLocalVariantGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentConfigurationIdentifier;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;
import org.jspecify.annotations.Nullable;

public class DefaultLocalVariantGraphResolveStateBuilder
implements LocalVariantGraphResolveStateBuilder {
    private final ComponentIdGenerator idGenerator;
    private final DependencyMetadataFactory dependencyMetadataFactory;
    private final ExcludeRuleConverter excludeRuleConverter;

    public DefaultLocalVariantGraphResolveStateBuilder(ComponentIdGenerator idGenerator, DependencyMetadataFactory dependencyMetadataFactory, ExcludeRuleConverter excludeRuleConverter) {
        this.idGenerator = idGenerator;
        this.dependencyMetadataFactory = dependencyMetadataFactory;
        this.excludeRuleConverter = excludeRuleConverter;
    }

    @Override
    public LocalVariantGraphResolveState createRootVariantState(ConfigurationInternal configuration, ComponentIdentifier componentId, LocalVariantGraphResolveStateBuilder.DependencyCache dependencyCache, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        DefaultLocalVariantGraphResolveStateBuilder.finalize(configuration, "resolved");
        ImmutableAttributes attributes = configuration.getAttributes().asImmutable();
        CalculatedValue<DefaultLocalVariantGraphResolveState.VariantDependencyMetadata> dependencies = this.getConfigurationDependencyState(configuration.asDescribable(), configuration.getHierarchy(), attributes, dependencyCache, model, calculatedValueContainerFactory);
        NamedVariantIdentifier id = new NamedVariantIdentifier(componentId, configuration.getName());
        ImmutableCapabilities capabilities = ImmutableCapabilities.of(Configurations.collectCapabilities(configuration, new HashSet<Capability>(), new HashSet<Configuration>()));
        DefaultLocalVariantGraphResolveMetadata metadata = new DefaultLocalVariantGraphResolveMetadata(id, configuration.getName(), configuration.isTransitive(), attributes, capabilities, false);
        return new DefaultLocalVariantGraphResolveState(this.idGenerator.nextVariantId(), metadata, dependencies, Collections.emptySet());
    }

    @Override
    public LocalVariantGraphResolveState createConsumableVariantState(ConfigurationInternal configuration, final ComponentIdentifier componentId, LocalVariantGraphResolveStateBuilder.DependencyCache dependencyCache, final ModelContainer<?> model, final CalculatedValueContainerFactory calculatedValueContainerFactory) {
        DefaultLocalVariantGraphResolveStateBuilder.finalize(configuration, "consumed as a variant");
        final String configurationName = configuration.getName();
        final ComponentConfigurationIdentifier configurationIdentifier = new ComponentConfigurationIdentifier(componentId, configurationName);
        ImmutableAttributes attributes = configuration.getAttributes().asImmutable();
        final ImmutableCapabilities capabilities = ImmutableCapabilities.of(Configurations.collectCapabilities(configuration, new HashSet<Capability>(), new HashSet<Configuration>()));
        final ImmutableSet.Builder artifactSets = ImmutableSet.builder();
        configuration.collectVariants(new ConfigurationInternal.VariantVisitor(){

            @Override
            public void visitOwnVariant(DisplayName displayName, ImmutableAttributes attributes, Collection<? extends PublishArtifact> artifacts) {
                CalculatedValue variantArtifacts = DefaultLocalVariantGraphResolveStateBuilder.getVariantArtifacts(displayName, componentId, artifacts, model, calculatedValueContainerFactory);
                artifactSets.add((Object)new LocalVariantMetadata(configurationName, (VariantResolveMetadata.Identifier)configurationIdentifier, displayName, attributes, capabilities, (CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>>)variantArtifacts));
            }

            @Override
            public void visitChildVariant(String name, DisplayName displayName, ImmutableAttributes attributes, Collection<? extends PublishArtifact> artifacts) {
                CalculatedValue variantArtifacts = DefaultLocalVariantGraphResolveStateBuilder.getVariantArtifacts(displayName, componentId, artifacts, model, calculatedValueContainerFactory);
                artifactSets.add((Object)new LocalVariantMetadata(configurationName + "-" + name, (VariantResolveMetadata.Identifier)new NonImplicitArtifactVariantIdentifier(configurationIdentifier, name), displayName, attributes, capabilities, (CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>>)variantArtifacts));
            }
        });
        CalculatedValue<DefaultLocalVariantGraphResolveState.VariantDependencyMetadata> dependencies = this.getConfigurationDependencyState(configuration.asDescribable(), configuration.getHierarchy(), attributes, dependencyCache, model, calculatedValueContainerFactory);
        NamedVariantIdentifier id = new NamedVariantIdentifier(componentId, configuration.getName());
        DefaultLocalVariantGraphResolveMetadata metadata = new DefaultLocalVariantGraphResolveMetadata(id, configurationName, configuration.isTransitive(), attributes, capabilities, configuration.isDeprecatedForConsumption());
        return new DefaultLocalVariantGraphResolveState(this.idGenerator.nextVariantId(), metadata, dependencies, (Set<LocalVariantMetadata>)artifactSets.build());
    }

    private static void finalize(ConfigurationInternal configuration, String reason) {
        configuration.runDependencyActions();
        configuration.markAsObserved(reason);
    }

    private static CalculatedValue<ImmutableList<LocalComponentArtifactMetadata>> getVariantArtifacts(DisplayName displayName, ComponentIdentifier componentId, Collection<? extends PublishArtifact> sourceArtifacts, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        return calculatedValueContainerFactory.create(Describables.of((Object)displayName, (Object)"artifacts"), context -> {
            if (sourceArtifacts.isEmpty()) {
                return ImmutableList.of();
            }
            return (ImmutableList)model.fromMutableState(m -> {
                ImmutableList.Builder result = ImmutableList.builderWithExpectedSize((int)sourceArtifacts.size());
                for (PublishArtifact sourceArtifact : sourceArtifacts) {
                    result.add((Object)new PublishArtifactLocalArtifactMetadata(componentId, sourceArtifact));
                }
                return result.build();
            });
        });
    }

    private CalculatedValue<DefaultLocalVariantGraphResolveState.VariantDependencyMetadata> getConfigurationDependencyState(DisplayName description, Set<Configuration> hierarchy, ImmutableAttributes attributes, LocalVariantGraphResolveStateBuilder.DependencyCache dependencyCache, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        return calculatedValueContainerFactory.create(Describables.of((Object)"Dependency state for", (Object)description), context -> (DefaultLocalVariantGraphResolveState.VariantDependencyMetadata)model.fromMutableState(p -> {
            ImmutableList.Builder dependencies = ImmutableList.builder();
            ImmutableSet.Builder files = ImmutableSet.builder();
            ImmutableList.Builder excludes = ImmutableList.builder();
            ArrayList<Configuration> sortedHierarchy = new ArrayList<Configuration>(hierarchy);
            sortedHierarchy.sort(Comparator.comparing(Named::getName));
            sortedHierarchy.forEach(config -> {
                LocalVariantGraphResolveStateBuilder.DependencyState defined = this.getDefinedState((ConfigurationInternal)config, dependencyCache);
                dependencies.addAll(defined.dependencies);
                files.addAll(defined.files);
                excludes.addAll(defined.excludes);
            });
            LocalVariantGraphResolveStateBuilder.DependencyState state = new LocalVariantGraphResolveStateBuilder.DependencyState((ImmutableList<LocalOriginDependencyMetadata>)dependencies.build(), (ImmutableSet<LocalFileDependencyMetadata>)files.build(), (ImmutableList<ExcludeMetadata>)excludes.build());
            return new DefaultLocalVariantGraphResolveState.VariantDependencyMetadata((List<LocalOriginDependencyMetadata>)DefaultLocalVariantGraphResolveStateBuilder.maybeForceDependencies(state.dependencies, attributes), (Set<LocalFileDependencyMetadata>)state.files, (List<ExcludeMetadata>)state.excludes);
        }));
    }

    private LocalVariantGraphResolveStateBuilder.DependencyState getDefinedState(ConfigurationInternal configuration, LocalVariantGraphResolveStateBuilder.DependencyCache cache) {
        return cache.computeIfAbsent(configuration, this::doGetDefinedState);
    }

    private LocalVariantGraphResolveStateBuilder.DependencyState doGetDefinedState(ConfigurationInternal configuration) {
        ImmutableList.Builder dependencyBuilder = ImmutableList.builder();
        ImmutableSet.Builder fileBuilder = ImmutableSet.builder();
        ImmutableList.Builder excludeBuilder = ImmutableList.builder();
        for (Dependency dependency : configuration.getDependencies()) {
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                dependencyBuilder.add((Object)this.dependencyMetadataFactory.createDependencyMetadata(moduleDependency));
                continue;
            }
            if (dependency instanceof FileCollectionDependency) {
                FileCollectionDependency fileDependency = (FileCollectionDependency)dependency;
                fileBuilder.add((Object)new DefaultLocalFileDependencyMetadata(fileDependency));
                continue;
            }
            throw new IllegalArgumentException("Cannot convert dependency " + dependency + " to local component dependency metadata.");
        }
        for (DependencyConstraint dependencyConstraint : configuration.getDependencyConstraints()) {
            dependencyBuilder.add((Object)this.dependencyMetadataFactory.createDependencyConstraintMetadata(dependencyConstraint));
        }
        for (ExcludeRule excludeRule : configuration.getExcludeRules()) {
            excludeBuilder.add((Object)this.excludeRuleConverter.convertExcludeRule(excludeRule));
        }
        configuration.markDependenciesObserved();
        return new LocalVariantGraphResolveStateBuilder.DependencyState((ImmutableList<LocalOriginDependencyMetadata>)dependencyBuilder.build(), (ImmutableSet<LocalFileDependencyMetadata>)fileBuilder.build(), (ImmutableList<ExcludeMetadata>)excludeBuilder.build());
    }

    private static ImmutableList<LocalOriginDependencyMetadata> maybeForceDependencies(ImmutableList<LocalOriginDependencyMetadata> dependencies, ImmutableAttributes attributes) {
        ImmutableAttributesEntry entry = attributes.findEntry(Category.CATEGORY_ATTRIBUTE);
        if (entry == null || !((Category)entry.getIsolatedValue()).getName().equals("enforced-platform")) {
            return dependencies;
        }
        ImmutableList.Builder forcedDependencies = ImmutableList.builder();
        for (LocalOriginDependencyMetadata rawDependency : dependencies) {
            forcedDependencies.add((Object)rawDependency.forced());
        }
        return forcedDependencies.build();
    }

    private static class DefaultLocalFileDependencyMetadata
    implements LocalFileDependencyMetadata {
        private final FileCollectionDependency fileDependency;

        DefaultLocalFileDependencyMetadata(FileCollectionDependency fileDependency) {
            this.fileDependency = fileDependency;
        }

        @Override
        public FileCollectionDependency getSource() {
            return this.fileDependency;
        }

        @Override
        public @Nullable ComponentIdentifier getComponentId() {
            return ((SelfResolvingDependencyInternal)this.fileDependency).getTargetComponentId();
        }

        @Override
        public FileCollectionInternal getFiles() {
            return (FileCollectionInternal)this.fileDependency.getFiles();
        }
    }

    private static class NonImplicitArtifactVariantIdentifier
    implements VariantResolveMetadata.Identifier {
        private final VariantResolveMetadata.Identifier parent;
        private final String name;
        private final int hashCode;

        public NonImplicitArtifactVariantIdentifier(VariantResolveMetadata.Identifier parent, String name) {
            this.parent = parent;
            this.name = name;
            this.hashCode = NonImplicitArtifactVariantIdentifier.computeHashCode(name, parent);
        }

        private static int computeHashCode(String name, VariantResolveMetadata.Identifier parent) {
            return 31 * parent.hashCode() + name.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NonImplicitArtifactVariantIdentifier other = (NonImplicitArtifactVariantIdentifier)obj;
            return this.parent.equals(other.parent) && this.name.equals(other.name);
        }
    }
}

