/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.util.Path;

public final class TaskIdentity<T extends Task> {
    public final Class<T> type;
    public final String name;
    public final Path projectPath;
    public final Path identityPath;
    public final Path buildPath;
    public final long uniqueId;
    private final ProjectIdentity projectIdentity;

    TaskIdentity(Class<T> type, String name, ProjectIdentity projectIdentity, long uniqueId) {
        this.name = name;
        this.type = type;
        this.projectIdentity = projectIdentity;
        this.uniqueId = uniqueId;
        this.projectPath = projectIdentity.getProjectPath().child(name);
        this.identityPath = projectIdentity.getBuildTreePath().child(name);
        this.buildPath = projectIdentity.getBuildPath();
    }

    public long getId() {
        return this.uniqueId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskIdentity that = (TaskIdentity)o;
        return this.uniqueId == that.uniqueId;
    }

    public int hashCode() {
        return (int)(this.uniqueId ^ this.uniqueId >>> 32);
    }

    public String toString() {
        return "TaskIdentity{path=" + this.identityPath + ", type=" + this.type + ", uniqueId=" + this.uniqueId + '}';
    }

    public String getTaskPath() {
        return this.projectPath.getPath();
    }

    public String getProjectPath() {
        return this.projectPath.getParent().getPath();
    }

    public String getIdentityPath() {
        return this.identityPath.getPath();
    }

    public String getBuildPath() {
        return this.buildPath.getPath();
    }

    public Class<T> getTaskType() {
        return this.type;
    }

    public ProjectIdentity getProjectIdentity() {
        return this.projectIdentity;
    }
}

