/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.plugins.ExtraPropertiesExtensionInternal;
import org.gradle.api.internal.project.ProjectHierarchyUtils;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.Environment;

public class ProjectPropertySettingBuildLoader
implements BuildLoader {
    private final GradleProperties gradleProperties;
    private final BuildLoader buildLoader;
    private final Environment environment;

    public ProjectPropertySettingBuildLoader(GradleProperties gradleProperties, BuildLoader buildLoader, Environment environment) {
        this.buildLoader = buildLoader;
        this.gradleProperties = gradleProperties;
        this.environment = environment;
    }

    @Override
    public void load(SettingsInternal settings, GradleInternal gradle) {
        this.buildLoader.load(settings, gradle);
        this.setProjectProperties(gradle.getRootProject());
    }

    private void setProjectProperties(Project project) {
        this.addPropertiesToProject(project);
        for (Project childProject : ProjectHierarchyUtils.getChildProjectsForInternalUse(project)) {
            this.setProjectProperties(childProject);
        }
    }

    private void addPropertiesToProject(Project project) {
        Map<String, String> intermediateProjectProperties = this.loadProjectGradleProperties(project);
        Map mergedProjectProperties = this.gradleProperties.mergeProperties(intermediateProjectProperties);
        ImmutableMap.Builder extraProjectPropertiesBuilder = ImmutableMap.builder();
        for (Map.Entry entry : mergedProjectProperties.entrySet()) {
            String propertyName = (String)entry.getKey();
            Object propertyValue = entry.getValue();
            ProjectPropertySettingBuildLoader.assignOrCollectProperty(project, (ImmutableMap.Builder<String, Object>)extraProjectPropertiesBuilder, propertyName, propertyValue);
        }
        ProjectPropertySettingBuildLoader.installProjectExtraPropertiesDefaults(project, (Map<String, Object>)extraProjectPropertiesBuilder.build());
    }

    private static void assignOrCollectProperty(Project project, ImmutableMap.Builder<String, Object> extraProjectProperties, String propertyName, Object propertyValue) {
        if (propertyName.isEmpty()) {
            return;
        }
        switch (propertyName) {
            case "version": {
                project.setVersion(propertyValue);
                break;
            }
            case "group": {
                project.setGroup(propertyValue);
                break;
            }
            case "description": {
                if (propertyValue instanceof String) {
                    project.setDescription((String)propertyValue);
                    break;
                }
                extraProjectProperties.put((Object)propertyName, propertyValue);
                break;
            }
            case "status": {
                project.setStatus(propertyValue);
                break;
            }
            case "buildDir": {
                project.setBuildDir(propertyValue);
                break;
            }
            default: {
                extraProjectProperties.put((Object)propertyName, propertyValue);
            }
        }
    }

    private Map<String, String> loadProjectGradleProperties(Project project) {
        File projectPropertiesFile = new File(project.getProjectDir(), "gradle.properties");
        Map<String, String> loadedProperties = this.environment.propertiesFile(projectPropertiesFile);
        return loadedProperties == null ? ImmutableMap.of() : loadedProperties;
    }

    private static void installProjectExtraPropertiesDefaults(Project project, Map<String, Object> extraProperties) {
        ExtraPropertiesExtensionInternal extraPropertiesContainer = (ExtraPropertiesExtensionInternal)project.getExtensions().getExtraProperties();
        extraPropertiesContainer.setGradleProperties(extraProperties);
    }
}

